/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FallbackResource
implements CompositeFontResource {
    FontResource primaryResource;
    private String[] linkedFontFiles;
    private String[] linkedFontNames;
    private FontResource[] fallbacks;
    private FontResource[] nativeFallbacks;
    private boolean isBold;
    private boolean isItalic;
    private int aaMode;
    private CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    static FallbackResource[] greyFallBackResource = new FallbackResource[4];
    static FallbackResource[] lcdFallBackResource = new FallbackResource[4];

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    FallbackResource(FontResource fontResource) {
        this.primaryResource = fontResource;
        this.aaMode = this.primaryResource.getDefaultAAMode();
        this.isBold = this.primaryResource.isBold();
        this.isItalic = this.primaryResource.isItalic();
    }

    static FallbackResource getFallbackResource(FontResource fontResource) {
        return new FallbackResource(fontResource);
    }

    FallbackResource(boolean bl, boolean bl2, int n) {
        this.isBold = bl;
        this.isItalic = bl2;
        this.aaMode = n;
    }

    static FallbackResource getFallbackResource(boolean bl, boolean bl2, int n) {
        FallbackResource fallbackResource;
        int n2;
        FallbackResource[] fallbackResourceArray = n == 0 ? greyFallBackResource : lcdFallBackResource;
        int n3 = n2 = bl ? 1 : 0;
        if (bl2) {
            n2 += 2;
        }
        if ((fallbackResource = fallbackResourceArray[n2]) == null) {
            fallbackResourceArray[n2] = fallbackResource = new FallbackResource(bl, bl2, n);
        }
        return fallbackResource;
    }

    @Override
    public int getDefaultAAMode() {
        return this.aaMode;
    }

    private String throwException() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFullName() {
        return this.throwException();
    }

    @Override
    public String getPSName() {
        return this.throwException();
    }

    @Override
    public String getFamilyName() {
        return this.throwException();
    }

    @Override
    public String getStyleName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFullName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFamilyName() {
        return this.throwException();
    }

    @Override
    public String getLocaleStyleName() {
        return this.throwException();
    }

    @Override
    public boolean isBold() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isItalic() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getFeatures() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFileName() {
        return this.throwException();
    }

    @Override
    public Object getPeer() {
        return null;
    }

    @Override
    public void setPeer(Object object) {
        this.throwException();
    }

    @Override
    public boolean isEmbeddedFont() {
        return false;
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    private int getSlotForFontNoCreate(String string) {
        this.getLinkedFonts();
        int n = 0;
        for (String object : this.linkedFontNames) {
            if (string.equalsIgnoreCase(object)) {
                return n;
            }
            ++n;
        }
        if (this.nativeFallbacks != null) {
            for (FontResource fontResource : this.nativeFallbacks) {
                if (string.equalsIgnoreCase(fontResource.getFullName())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    public int getSlotForFont(String string) {
        int n = this.getSlotForFontNoCreate(string);
        if (n >= 0) {
            return n;
        }
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        FontResource fontResource = prismFontFactory.getFontResource(string, null, false);
        if (fontResource == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t Font name not supported \"" + string + "\".");
            }
            return -1;
        }
        n = this.getSlotForFontNoCreate(fontResource.getFullName());
        if (n >= 0) {
            return n;
        }
        return this.addNativeFallback(fontResource);
    }

    private int addNativeFallback(FontResource fontResource) {
        FontResource[] fontResourceArray;
        int n = this.getNumSlots();
        if (n >= 126) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tToo many font fallbacks!");
            }
            return -1;
        }
        if (this.nativeFallbacks == null) {
            fontResourceArray = new FontResource[1];
        } else {
            fontResourceArray = new FontResource[this.nativeFallbacks.length + 1];
            System.arraycopy(this.nativeFallbacks, 0, fontResourceArray, 0, this.nativeFallbacks.length);
        }
        fontResourceArray[fontResourceArray.length - 1] = fontResource;
        this.nativeFallbacks = fontResourceArray;
        return n + 1;
    }

    @Override
    public int addSlotFont(FontResource fontResource) {
        int n = this.getSlotForFont(fontResource.getFullName());
        if (n >= 0) {
            return n;
        }
        return this.addNativeFallback(fontResource);
    }

    private void getLinkedFonts() {
        if (this.fallbacks == null) {
            PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
            FontFallbackInfo fontFallbackInfo = prismFontFactory.getFallbacks(this.primaryResource);
            this.linkedFontNames = fontFallbackInfo.getFontNames();
            this.linkedFontFiles = fontFallbackInfo.getFontFiles();
            this.fallbacks = fontFallbackInfo.getFonts();
        }
    }

    @Override
    public int getNumSlots() {
        this.getLinkedFonts();
        int n = this.fallbacks.length;
        if (this.nativeFallbacks != null) {
            n += this.nativeFallbacks.length;
        }
        return n;
    }

    @Override
    public float[] getGlyphBoundingBox(int n, float f, float[] fArray) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getGlyphBoundingBox(n3, f, fArray);
    }

    @Override
    public float getAdvance(int n, float f) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getAdvance(n3, f);
    }

    @Override
    public synchronized FontResource getSlotResource(int n) {
        this.getLinkedFonts();
        if (n >= this.fallbacks.length) {
            if (this.nativeFallbacks == null || (n -= this.fallbacks.length) >= this.nativeFallbacks.length) {
                return null;
            }
            return this.nativeFallbacks[n];
        }
        if (this.fallbacks[n] == null) {
            String string = this.linkedFontFiles[n];
            String string2 = this.linkedFontNames[n];
            this.fallbacks[n] = PrismFontFactory.getFontFactory().getFontResource(string2, string, false);
        }
        return this.fallbacks[n];
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform) {
        return this.getStrike(f, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform, int n) {
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(f, baseTransform, n);
        WeakReference<CompositeStrike> weakReference = this.strikeMap.get(fontStrikeDesc);
        CompositeStrike compositeStrike = null;
        if (weakReference != null) {
            compositeStrike = (CompositeStrike)weakReference.get();
        }
        if (compositeStrike == null) {
            compositeStrike = new CompositeStrike(this, f, baseTransform, n, fontStrikeDesc);
            weakReference = compositeStrike.disposer != null ? Disposer.addRecord(compositeStrike, compositeStrike.disposer) : new WeakReference<CompositeStrike>(compositeStrike);
            this.strikeMap.put(fontStrikeDesc, weakReference);
        }
        return compositeStrike;
    }

    public String toString() {
        int n = this.getNumSlots();
        Object object = "Fallback resource:\n";
        for (int i = 0; i < n; ++i) {
            object = this.getSlotResource(i) == null ? (String)object + "Slot " + i + "=null\n" : (String)object + "Slot " + i + "=" + this.getSlotResource(i).getFullName() + "\n";
        }
        object = (String)object + "\n";
        return object;
    }
}

