/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.Converters;
import com.sun.jfx.incubator.scene.control.richtext.RichTextFormatHandlerHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javafx.scene.input.DataFormat;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.DataFormatHandler;
import jfx.incubator.scene.control.richtext.model.ParagraphDirection;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class RichTextFormatHandler
extends DataFormatHandler {
    private static final boolean DEBUG = false;
    public static final DataFormat DATA_FORMAT;
    private static final StringConverter<Boolean> BOOLEAN_CONVERTER;
    private static final StringConverter<Color> COLOR_CONVERTER;
    private static final StringConverter<ParagraphDirection> DIRECTION_CONVERTER;
    private static final DoubleStringConverter DOUBLE_CONVERTER;
    private static final StringConverter<String> STRING_CONVERTER;
    private static final StringConverter<TextAlignment> TEXT_ALIGNMENT_CONVERTER;
    private final HashMap<Object, Handler> handlers = new HashMap(64);
    private static final RichTextFormatHandler instance;

    private RichTextFormatHandler() {
        super(DATA_FORMAT);
        this.addHandlerBoolean(StyleAttributeMap.BOLD, "b");
        this.addHandler(StyleAttributeMap.BACKGROUND, "bg", COLOR_CONVERTER);
        this.addHandlerString(StyleAttributeMap.BULLET, "bullet");
        this.addHandlerString(StyleAttributeMap.FONT_FAMILY, "ff");
        this.addHandler(StyleAttributeMap.FIRST_LINE_INDENT, "firstIndent", (StringConverter)DOUBLE_CONVERTER);
        this.addHandler(StyleAttributeMap.FONT_SIZE, "fs", (StringConverter)DOUBLE_CONVERTER);
        this.addHandlerBoolean(StyleAttributeMap.ITALIC, "i");
        this.addHandler(StyleAttributeMap.LINE_SPACING, "lineSpacing", (StringConverter)DOUBLE_CONVERTER);
        this.addHandler(StyleAttributeMap.PARAGRAPH_DIRECTION, "dir", DIRECTION_CONVERTER);
        this.addHandler(StyleAttributeMap.SPACE_ABOVE, "spaceAbove", (StringConverter)DOUBLE_CONVERTER);
        this.addHandler(StyleAttributeMap.SPACE_BELOW, "spaceBelow", (StringConverter)DOUBLE_CONVERTER);
        this.addHandler(StyleAttributeMap.SPACE_LEFT, "spaceLeft", (StringConverter)DOUBLE_CONVERTER);
        this.addHandler(StyleAttributeMap.SPACE_RIGHT, "spaceRight", (StringConverter)DOUBLE_CONVERTER);
        this.addHandlerBoolean(StyleAttributeMap.STRIKE_THROUGH, "ss");
        this.addHandler(StyleAttributeMap.TEXT_ALIGNMENT, "alignment", TEXT_ALIGNMENT_CONVERTER);
        this.addHandler(StyleAttributeMap.TEXT_COLOR, "tc", COLOR_CONVERTER);
        this.addHandlerBoolean(StyleAttributeMap.UNDERLINE, "u");
    }

    public static final RichTextFormatHandler getInstance() {
        return instance;
    }

    private static void initAccessor() {
        RichTextFormatHandlerHelper.setAccessor(new RichTextFormatHandlerHelper.Accessor(){

            @Override
            public StyledOutput createStyledOutput(RichTextFormatHandler richTextFormatHandler, StyleResolver styleResolver, Writer writer) {
                return richTextFormatHandler.createStyledOutput(styleResolver, writer);
            }
        });
    }

    @Override
    public StyledInput createStyledInput(String string, StyleAttributeMap styleAttributeMap) {
        return new RichStyledInput(string);
    }

    @Override
    public Object copy(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        StyledOutput styledOutput = this.createStyledOutput(styleResolver, stringWriter);
        styledTextModel.export(textPos, textPos2, styledOutput);
        return stringWriter.toString();
    }

    @Override
    public void save(StyledTextModel styledTextModel, StyleResolver styleResolver, TextPos textPos, TextPos textPos2, OutputStream outputStream) throws IOException {
        Charset charset = Charset.forName("utf-8");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        StyledOutput styledOutput = this.createStyledOutput(styleResolver, outputStreamWriter);
        styledTextModel.export(textPos, textPos2, styledOutput);
    }

    private StyledOutput createStyledOutput(StyleResolver styleResolver, Writer writer) {
        Charset charset = Charset.forName("utf-8");
        boolean bl = RichTextFormatHandler.isBuffered(writer);
        if (bl) {
            return new RichStyledOutput(styleResolver, writer);
        }
        writer = new BufferedWriter(writer);
        return new RichStyledOutput(styleResolver, writer);
    }

    private static boolean isBuffered(Writer writer) {
        return writer instanceof BufferedWriter || writer instanceof StringWriter;
    }

    private <T> void addHandler(StyleAttribute<T> styleAttribute, String string, StringConverter<T> stringConverter) {
        this.addHandler(new Handler<T>(styleAttribute, string, stringConverter));
    }

    private <T> void addHandler(Handler<T> handler) {
        this.handlers.put(handler.getStyleAttribute(), handler);
        this.handlers.put(handler.getId(), handler);
    }

    private void addHandlerBoolean(StyleAttribute<Boolean> styleAttribute, String string) {
        this.addHandler(new Handler<Boolean>(this, styleAttribute, string, BOOLEAN_CONVERTER){

            @Override
            public boolean isAllowed(Boolean bl) {
                return Boolean.TRUE.equals(bl);
            }
        });
    }

    private void addHandlerString(StyleAttribute<String> styleAttribute, String string) {
        this.addHandler(new Handler<String>(styleAttribute, string, STRING_CONVERTER));
    }

    private static void log(Object object) {
    }

    static {
        RichTextFormatHandler.initAccessor();
        DATA_FORMAT = new DataFormat(new String[]{"application/x-com-oracle-editable-rich-text"});
        BOOLEAN_CONVERTER = Converters.booleanConverter();
        COLOR_CONVERTER = Converters.colorConverter();
        DIRECTION_CONVERTER = Converters.paragraphDirectionConverter();
        DOUBLE_CONVERTER = new DoubleStringConverter();
        STRING_CONVERTER = Converters.stringConverter();
        TEXT_ALIGNMENT_CONVERTER = Converters.textAlignmentConverter();
        instance = new RichTextFormatHandler();
    }

    private class RichStyledInput
    implements StyledInput {
        private final String text;
        private int index;
        private StringBuilder sb;
        private final ArrayList<StyleAttributeMap> styles = new ArrayList();
        private int line = 1;

        public RichStyledInput(String string) {
            this.text = string;
        }

        @Override
        public StyledSegment nextSegment() {
            try {
                int n = this.charAt(0);
                switch (n) {
                    case -1: {
                        return null;
                    }
                    case 10: {
                        ++this.index;
                        ++this.line;
                        return StyledSegment.LINE_BREAK;
                    }
                    case 123: {
                        StyleAttributeMap styleAttributeMap = this.parseAttributes(true);
                        if (styleAttributeMap != null) {
                            if (styleAttributeMap.isEmpty()) {
                                styleAttributeMap = null;
                            }
                            return StyledSegment.ofParagraphAttributes(styleAttributeMap);
                        }
                        styleAttributeMap = this.parseAttributes(false);
                        String string = this.decodeText();
                        return StyledSegment.of(string, styleAttributeMap);
                    }
                }
                String string = this.decodeText();
                return StyledSegment.of(string);
            }
            catch (IOException iOException) {
                this.err(iOException);
                return null;
            }
        }

        @Override
        public void close() throws IOException {
        }

        private StyleAttributeMap parseAttributes(boolean bl) throws IOException {
            int n;
            StyleAttributeMap.Builder builder = null;
            while ((n = this.charAt(0)) == 123) {
                n = this.charAt(1);
                if (bl) {
                    if (n != 33) break;
                    ++this.index;
                } else if (n == 33) {
                    throw this.err("unexpected paragraph attribute");
                }
                ++this.index;
                int n2 = this.text.indexOf(125, this.index);
                if (n2 < 0) {
                    throw this.err("missing }");
                }
                String string = this.text.substring(this.index, n2);
                if (string.length() == 0) {
                    if (bl) {
                        this.index = n2 + 1;
                        return StyleAttributeMap.EMPTY;
                    }
                    throw this.err("empty attribute name");
                }
                int n3 = this.parseStyleNumber(string);
                if (n3 < 0) {
                    String string2;
                    String string3;
                    int n4 = string.indexOf(124);
                    if (n4 < 0) {
                        string3 = string;
                        string2 = null;
                    } else {
                        string3 = string.substring(0, n4);
                        string2 = string.substring(n4 + 1);
                    }
                    Handler handler = RichTextFormatHandler.this.handlers.get(string3);
                    if (handler == null) {
                        RichTextFormatHandler.log("ignoring attribute: " + string3);
                    } else {
                        Object t = handler.read(string2);
                        StyleAttribute styleAttribute = handler.getStyleAttribute();
                        if (styleAttribute.isParagraphAttribute() != bl) {
                            throw this.err("paragraph type mismatch");
                        }
                        if (builder == null) {
                            builder = StyleAttributeMap.builder();
                        }
                        builder.set(styleAttribute, t);
                    }
                    this.index = n2 + 1;
                    continue;
                }
                this.index = n2 + 1;
                return this.styles.get(n3);
            }
            if (builder == null) {
                return null;
            }
            StyleAttributeMap styleAttributeMap = builder.build();
            this.styles.add(styleAttributeMap);
            return styleAttributeMap;
        }

        private int charAt(int n) {
            int n2 = this.index + n;
            if (n2 >= this.text.length()) {
                return -1;
            }
            return this.text.charAt(n2);
        }

        private String decodeText() throws IOException {
            int n = this.index;
            while (true) {
                int n2 = this.charAt(0);
                switch (n2) {
                    case -1: 
                    case 10: 
                    case 123: {
                        return this.text.substring(n, this.index);
                    }
                    case 37: {
                        return this.decodeText(n, this.index);
                    }
                }
                ++this.index;
            }
        }

        private String decodeText(int n, int n2) throws IOException {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            if (n2 > n) {
                this.sb.append(this.text, n, n2);
            }
            while (true) {
                int n3 = this.charAt(0);
                switch (n3) {
                    case -1: 
                    case 10: 
                    case 123: {
                        String string = this.sb.toString();
                        this.sb.setLength(0);
                        return string;
                    }
                    case 37: {
                        ++this.index;
                        int n4 = this.decodeHexByte();
                        this.sb.append((char)n4);
                    }
                }
                ++this.index;
            }
        }

        private int decodeHexByte() throws IOException {
            int n = RichStyledInput.decodeHex(this.charAt(0)) << 4;
            ++this.index;
            return n += RichStyledInput.decodeHex(this.charAt(0));
        }

        private static int decodeHex(int n) throws IOException {
            int n2 = n - 48;
            if (n2 >= 0 && n2 <= 9) {
                return n2;
            }
            n2 = n - 55;
            if (n2 >= 10 && n2 <= 15) {
                return n2;
            }
            n2 = n - 97;
            if (n2 >= 10 && n2 <= 15) {
                return n2;
            }
            throw new IOException("not a hex char:" + n);
        }

        private int parseStyleNumber(String string) throws IOException {
            if (Character.isDigit(string.charAt(0))) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.err("invalid style number " + string);
                }
            }
            return -1;
        }

        private IOException err(Object object) {
            return new IOException("malformed input: " + String.valueOf(object) + ", line " + this.line);
        }
    }

    private class RichStyledOutput
    implements StyledOutput {
        private final StyleResolver resolver;
        private final Writer wr;
        private HashMap<StyleAttributeMap, Integer> styles = new HashMap();

        public RichStyledOutput(StyleResolver styleResolver, Writer writer) {
            this.resolver = styleResolver;
            this.wr = writer;
        }

        @Override
        public void consume(StyledSegment styledSegment) throws IOException {
            switch (styledSegment.getType()) {
                case INLINE_NODE: {
                    RichTextFormatHandler.log("ignoring embedded node");
                    break;
                }
                case LINE_BREAK: {
                    this.wr.write("\n");
                    break;
                }
                case PARAGRAPH_ATTRIBUTES: {
                    StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(this.resolver);
                    this.emitAttributes(styleAttributeMap, true);
                    break;
                }
                case REGION: {
                    break;
                }
                case TEXT: {
                    StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(this.resolver);
                    this.emitAttributes(styleAttributeMap, false);
                    String string = styledSegment.getText();
                    string = RichStyledOutput.encode(string);
                    this.wr.write(string);
                }
            }
        }

        private void emitAttributes(StyleAttributeMap styleAttributeMap, boolean bl) throws IOException {
            if (styleAttributeMap != null && !styleAttributeMap.isEmpty()) {
                Integer n = this.styles.get(styleAttributeMap);
                if (n == null) {
                    int n2 = this.styles.size();
                    this.styles.put(styleAttributeMap, n2);
                    ArrayList arrayList = new ArrayList(styleAttributeMap.getAttributes());
                    Collections.sort(arrayList, new Comparator<StyleAttribute<?>>(this){

                        @Override
                        public int compare(StyleAttribute<?> styleAttribute, StyleAttribute<?> styleAttribute2) {
                            String string = styleAttribute.getName();
                            String string2 = styleAttribute2.getName();
                            return string.compareTo(string2);
                        }
                    });
                    for (StyleAttribute<?> styleAttribute : arrayList) {
                        Handler handler = RichTextFormatHandler.this.handlers.get(styleAttribute);
                        try {
                            if (handler != null) {
                                Object obj = styleAttributeMap.get(styleAttribute);
                                if (!handler.isAllowed(obj)) continue;
                                this.wr.write(123);
                                if (bl) {
                                    this.wr.write(33);
                                }
                                this.wr.write(handler.getId());
                                String string = handler.write(obj);
                                if (string != null) {
                                    this.wr.write(124);
                                    this.wr.write(RichStyledOutput.encode(string));
                                }
                                this.wr.write(125);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            RichTextFormatHandler.log(exception);
                        }
                        RichTextFormatHandler.log("failed to emit " + String.valueOf(styleAttribute) + ", skipping");
                    }
                } else {
                    this.wr.write(123);
                    if (bl) {
                        this.wr.write(33);
                    }
                    this.wr.write(String.valueOf(n));
                    this.wr.write(125);
                }
            } else if (bl) {
                this.wr.write("{!}");
            }
        }

        private static String encode(String string) {
            if (string == null) {
                return "";
            }
            int n = RichStyledOutput.indexOfSpecialChar(string);
            if (n < 0) {
                return string;
            }
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 32);
            if (n > 0) {
                stringBuilder.append(string.substring(0, n));
            }
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (RichStyledOutput.isSpecialChar(c)) {
                    stringBuilder.append(String.format("%%%02X", c));
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        private static int indexOfSpecialChar(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!RichStyledOutput.isSpecialChar(c)) continue;
                return i;
            }
            return -1;
        }

        private static boolean isSpecialChar(char c) {
            switch (c) {
                case '%': 
                case '{': 
                case '|': 
                case '}': {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void flush() throws IOException {
            this.wr.flush();
        }

        @Override
        public void close() throws IOException {
            this.wr.close();
        }
    }

    static class Handler<T> {
        private final String id;
        private final StyleAttribute<T> attribute;
        private final StringConverter<T> converter;

        public Handler(StyleAttribute<T> styleAttribute, String string, StringConverter<T> stringConverter) {
            this.id = string;
            this.attribute = styleAttribute;
            this.converter = stringConverter;
        }

        public String getId() {
            return this.id;
        }

        public StyleAttribute<T> getStyleAttribute() {
            return this.attribute;
        }

        public boolean isAllowed(T t) {
            return true;
        }

        public String write(T t) {
            return this.converter.toString(t);
        }

        public T read(String string) {
            return (T)this.converter.fromString(string);
        }
    }
}

