/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.JsonParseException;
import com.github.erosb.jsonsKema.TextLocation;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/github/erosb/jsonsKema/SourceWalker;", "", "inputReader", "Ljava/io/Reader;", "documentSource", "Ljava/net/URI;", "<init>", "(Ljava/io/Reader;Ljava/net/URI;)V", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/net/URI;)V", "reader", "lineNumber", "", "position", "curr", "", "currInt", "skipWhitespaces", "reachedEOF", "", "consume", "token", "", "forward", "", "readUntil", "terminator", "location", "Lcom/github/erosb/jsonsKema/TextLocation;", "getLocation", "()Lcom/github/erosb/jsonsKema/TextLocation;", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonParser.kt\ncom/github/erosb/jsonsKema/SourceWalker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
final class SourceWalker {
    @NotNull
    private final URI documentSource;
    @NotNull
    private final Reader reader;
    private int lineNumber;
    private int position;

    /*
     * WARNING - void declaration
     */
    public SourceWalker(@NotNull Reader inputReader, @NotNull URI documentSource) {
        void it;
        Intrinsics.checkNotNullParameter(inputReader, "inputReader");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        this.documentSource = documentSource;
        Reader reader = inputReader;
        SourceWalker sourceWalker = this;
        boolean bl = false;
        sourceWalker.reader = it.markSupported() ? it : (Reader)new BufferedReader((Reader)it);
        this.reader.markSupported();
        this.lineNumber = 1;
        this.position = 1;
    }

    public SourceWalker(@NotNull InputStream input, @NotNull URI documentSource) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(documentSource, "documentSource");
        this(new BufferedReader(new InputStreamReader(input)), documentSource);
    }

    public final char curr() {
        int currInt = this.currInt();
        if (currInt == -1) {
            throw new JsonParseException("Unexpected EOF", this.getLocation());
        }
        return (char)currInt;
    }

    private final int currInt() {
        this.reader.mark(1);
        int c = this.reader.read();
        this.reader.reset();
        return c;
    }

    @NotNull
    public final SourceWalker skipWhitespaces() {
        while (true) {
            this.reader.mark(1);
            int c = this.reader.read();
            char c2 = (char)c;
            if (c == -1 || c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r') break;
            if (c2 == '\r' && this.currInt() == 10) {
                this.reader.read();
            }
            switch (c2) {
                case '\n': 
                case '\r': {
                    this.position = 1;
                    int n = ++this.lineNumber;
                    break;
                }
                default: {
                    int n = ++this.position;
                }
            }
        }
        this.reader.reset();
        return this;
    }

    public final boolean reachedEOF() {
        return this.currInt() == -1;
    }

    @NotNull
    public final SourceWalker consume(@NotNull String token) {
        Intrinsics.checkNotNullParameter(token, "token");
        token.chars().forEach(arg_0 -> SourceWalker.consume$lambda$1(this, arg_0));
        return this;
    }

    public final void forward() {
        this.reader.read();
        ++this.position;
    }

    @NotNull
    public final String readUntil(char terminator) {
        StringBuilder buffer = new StringBuilder();
        while (true) {
            char ch = this.curr();
            this.forward();
            if (ch == terminator) break;
            buffer.append(ch);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final TextLocation getLocation() {
        return new TextLocation(this.lineNumber, this.position, this.documentSource);
    }

    private static final void consume$lambda$1(SourceWalker this$0, int i) {
        char toChar = (char)i;
        char ch = this$0.curr();
        if (toChar != ch) {
            throw new JsonParseException("Unexpected character found: " + ch, this$0.getLocation());
        }
        this$0.reader.read();
        ++this$0.position;
        int cfr_ignored_0 = this$0.position;
    }
}

