/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.extract;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.List;

public class ASiCWithCAdESContainerExtractor
extends DefaultASiCContainerExtractor {
    public ASiCWithCAdESContainerExtractor(DSSDocument archive) {
        super(archive);
    }

    @Override
    public boolean isSupportedContainerFormat() {
        List<String> filenames = ZipUtils.getInstance().extractEntryNames(this.asicContainer);
        return ASiCUtils.isAsicFileContent(filenames);
    }

    @Override
    protected boolean isAllowedManifest(String entryName) {
        return ASiCUtils.isManifest(entryName);
    }

    @Override
    protected boolean isAllowedArchiveManifest(String entryName) {
        return ASiCUtils.isArchiveManifest(entryName);
    }

    @Override
    protected boolean isAllowedEvidenceRecordManifest(String entryName) {
        return ASiCUtils.isEvidenceRecordManifest(entryName);
    }

    @Override
    protected boolean isAllowedSignature(String entryName) {
        return ASiCUtils.isCAdES(entryName);
    }

    @Override
    protected boolean isAllowedTimestamp(String entryName) {
        return ASiCUtils.isTimestamp(entryName);
    }

    @Override
    protected boolean isAllowedEvidenceRecord(String entryName) {
        return ASiCUtils.isEvidenceRecord(entryName);
    }
}

