/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.extract;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFormatDetector;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractorFactory;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Objects;

public class ASiCWithCAdESContainerExtractorFactory
implements ASiCContainerExtractorFactory {
    @Override
    public boolean isSupported(DSSDocument asicContainer) {
        Objects.requireNonNull(asicContainer, "ASiC container cannot be null!");
        return new ASiCWithCAdESFormatDetector().isSupportedZip(asicContainer);
    }

    @Override
    public ASiCContainerExtractor create(DSSDocument asicContainer) {
        Objects.requireNonNull(asicContainer, "ASiC container cannot be null!");
        if (!this.isSupported(asicContainer)) {
            throw new UnsupportedOperationException("The ASiC container is not supported by ASiC with CAdES container extractor factory!");
        }
        return new ASiCWithCAdESContainerExtractor(asicContainer);
    }
}

