/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.merge;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFormatDetector;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.merge.DefaultContainerMerger;
import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public abstract class AbstractASiCWithCAdESContainerMerger
extends DefaultContainerMerger {
    protected ASiCWithCAdESFilenameFactory asicFilenameFactory = new DefaultASiCWithCAdESFilenameFactory();
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = CAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;

    AbstractASiCWithCAdESContainerMerger() {
    }

    protected AbstractASiCWithCAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    protected AbstractASiCWithCAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    public void setAsicFilenameFactory(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        Objects.requireNonNull(asicFilenameFactory, "ASiCWithCAdESFilenameFactory cannot be null!");
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = CMSUtils.getDSSResourcesHandlerBuilder(resourcesHandlerBuilder);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return new ASiCWithCAdESFormatDetector().isSupportedZip(container);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return new ASiCWithCAdESFormatDetector().isSupportedZip(asicContent);
    }

    @Override
    protected DefaultASiCContainerExtractor getContainerExtractor(DSSDocument container) {
        return new ASiCWithCAdESContainerExtractor(container);
    }

    protected DSSDocument mergeCmsSignatures(List<DSSDocument> signatureDocuments) {
        try {
            List<CMS> cmsList = this.getCMSList(signatureDocuments);
            CMS originalCMS = cmsList.iterator().next();
            SignerInformationStore signerInformationStore = this.getSignerInformationStore(cmsList);
            CMS mergedCMS = CMSUtils.replaceSigners(originalCMS, signerInformationStore);
            Store<X509CertificateHolder> certificatesStore = this.getCertificatesStore(cmsList);
            Store<X509AttributeCertificateHolder> certAttributeStore = this.getCertAttributeStore(cmsList);
            Store<X509CRLHolder> crlStore = this.getCRLStore(cmsList);
            Store<ASN1Encodable> ocspResponesStore = this.getOCSPResponsesStore(cmsList);
            Store<ASN1Encodable> ocspBasicStore = this.getOCSPBasicStore(cmsList);
            mergedCMS = CMSUtils.replaceCertificatesAndCRLs(mergedCMS, certificatesStore, certAttributeStore, crlStore, ocspResponesStore, ocspBasicStore);
            List<AlgorithmIdentifier> digestAlgorithms = this.getDigestAlgorithms(cmsList);
            mergedCMS = CMSUtils.populateDigestAlgorithmSet(mergedCMS, digestAlgorithms);
            DSSDocument cmsDocument = CMSUtils.writeToDSSDocument(mergedCMS, this.resourcesHandlerBuilder);
            cmsDocument.setName(this.getSignatureDocumentName(signatureDocuments));
            return cmsDocument;
        }
        catch (CertificateEncodingException e) {
            throw new DSSException(String.format("Unable to merge ASiC-S with CAdES container. Reason : %s", e.getMessage()));
        }
    }

    private List<CMS> getCMSList(List<DSSDocument> signatureDocuments) {
        ArrayList<CMS> signedDataList = new ArrayList<CMS>();
        for (DSSDocument signatureDocument : signatureDocuments) {
            CMSDocumentAnalyzer documentValidator = new CMSDocumentAnalyzer(signatureDocument);
            signedDataList.add(documentValidator.getCMS());
        }
        return signedDataList;
    }

    private SignerInformationStore getSignerInformationStore(List<CMS> cmsList) {
        ArrayList<SignerInformation> signerInformations = new ArrayList<SignerInformation>();
        for (CMS signedData : cmsList) {
            signerInformations.addAll(signedData.getSignerInfos().getSigners());
        }
        return new SignerInformationStore(signerInformations);
    }

    private Store<X509CertificateHolder> getCertificatesStore(List<CMS> cmsList) throws CertificateEncodingException {
        LinkedHashSet<X509CertificateHolder> result = new LinkedHashSet<X509CertificateHolder>();
        for (CMS signedData : cmsList) {
            result.addAll(signedData.getCertificates().getMatches(null));
        }
        return new JcaCertStore(result);
    }

    private Store<X509AttributeCertificateHolder> getCertAttributeStore(List<CMS> cmsList) {
        LinkedHashSet<X509AttributeCertificateHolder> result = new LinkedHashSet<X509AttributeCertificateHolder>();
        for (CMS signedData : cmsList) {
            result.addAll(signedData.getAttributeCertificates().getMatches(null));
        }
        return new CollectionStore<X509AttributeCertificateHolder>(result);
    }

    private Store<X509CRLHolder> getCRLStore(List<CMS> cmsList) {
        LinkedHashSet<X509CRLHolder> result = new LinkedHashSet<X509CRLHolder>();
        for (CMS cms : cmsList) {
            result.addAll(cms.getCRLs().getMatches(null));
        }
        return new CollectionStore<X509CRLHolder>(result);
    }

    private Store<ASN1Encodable> getOCSPResponsesStore(List<CMS> cmsList) {
        LinkedHashSet<ASN1Encodable> result = new LinkedHashSet<ASN1Encodable>();
        for (CMS cms : cmsList) {
            Collection<?> basicOcsps = cms.getOcspResponseStore().getMatches(null);
            for (Object ocsp : basicOcsps) {
                ASN1Encodable asn1EncodableOcsp = (ASN1Encodable)ocsp;
                result.add(asn1EncodableOcsp);
            }
        }
        return new CollectionStore<ASN1Encodable>(result);
    }

    private Store<ASN1Encodable> getOCSPBasicStore(List<CMS> cmsList) {
        LinkedHashSet<ASN1Encodable> result = new LinkedHashSet<ASN1Encodable>();
        for (CMS cms : cmsList) {
            Collection<?> basicOcsps = cms.getOcspBasicStore().getMatches(null);
            for (Object ocsp : basicOcsps) {
                ASN1Encodable asn1EncodableOcsp = (ASN1Encodable)ocsp;
                result.add(asn1EncodableOcsp);
            }
        }
        return new CollectionStore<ASN1Encodable>(result);
    }

    private List<AlgorithmIdentifier> getDigestAlgorithms(List<CMS> cmsList) {
        ArrayList<AlgorithmIdentifier> result = new ArrayList<AlgorithmIdentifier>();
        for (CMS cms : cmsList) {
            result.addAll(cms.getDigestAlgorithmIDs());
        }
        return result;
    }

    private String getSignatureDocumentName(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionNotEmpty(signatureDocuments)) {
            return signatureDocuments.get(0).getName();
        }
        throw new IllegalInputException("At least one signature file shall be provided for merging!");
    }

    protected List<DSSDocument> getAllSignatureDocuments(ASiCContent ... asicContents) {
        ArrayList<DSSDocument> signatureDocuments = new ArrayList<DSSDocument>();
        for (ASiCContent asicContent : asicContents) {
            signatureDocuments.addAll(asicContent.getSignatureDocuments());
        }
        return signatureDocuments;
    }
}

