/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.zip.ZipEntry;

public class DSSZipEntry
implements Serializable {
    private static final long serialVersionUID = -6639922911484163896L;
    private String name;
    private String comment;
    private int compressionMethod = 8;
    private FileTime creationTime;
    private byte[] extra;
    private FileTime modificationTime;
    private FileTime lastAccessTime;
    private long size;
    private long compressedSize;
    private long crc;

    public DSSZipEntry(String name) {
        Objects.requireNonNull(name, "Name cannot be null!");
        this.name = name;
    }

    public DSSZipEntry(ZipEntry zipEntry) {
        Objects.requireNonNull(zipEntry, "ZipEntry cannot be null!");
        this.name = zipEntry.getName();
        if (zipEntry.getComment() != null) {
            this.comment = zipEntry.getComment();
        }
        if (zipEntry.getMethod() != -1) {
            this.compressionMethod = zipEntry.getMethod();
        }
        if (zipEntry.getCreationTime() != null) {
            this.creationTime = zipEntry.getCreationTime();
        }
        if (zipEntry.getExtra() != null) {
            this.extra = zipEntry.getExtra();
        }
        if (zipEntry.getLastModifiedTime() != null) {
            this.modificationTime = zipEntry.getLastModifiedTime();
        }
        if (zipEntry.getLastAccessTime() != null) {
            this.lastAccessTime = zipEntry.getLastAccessTime();
        }
        if (zipEntry.getSize() != -1L) {
            this.size = zipEntry.getSize();
        }
        if (zipEntry.getCompressedSize() != -1L) {
            this.compressedSize = zipEntry.getCompressedSize();
        }
        if (zipEntry.getCrc() != -1L) {
            this.crc = zipEntry.getCrc();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public FileTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(FileTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime != null ? this.toFileTime(creationTime) : null;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setExtra(byte[] extra) {
        this.extra = extra;
    }

    public Date getModificationTime() {
        return this.modificationTime != null ? this.toDate(this.modificationTime) : null;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime != null ? this.toDate(this.lastAccessTime) : null;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public ZipEntry createZipEntry() {
        ZipEntry zipEntry = new ZipEntry(this.name);
        if (this.comment != null) {
            zipEntry.setComment(this.comment);
        }
        if (this.compressionMethod != -1) {
            zipEntry.setMethod(this.compressionMethod);
        }
        if (this.creationTime != null) {
            zipEntry.setCreationTime(this.creationTime);
        }
        if (this.extra != null) {
            zipEntry.setExtra(this.extra);
        }
        return zipEntry;
    }

    private FileTime toFileTime(Date date) {
        return FileTime.fromMillis(date.getTime());
    }

    private Date toDate(FileTime fileTime) {
        return new Date(fileTime.toMillis());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DSSZipEntry that = (DSSZipEntry)o;
        return this.compressionMethod == that.compressionMethod && this.size == that.size && this.compressedSize == that.compressedSize && this.crc == that.crc && Objects.equals(this.name, that.name) && Objects.equals(this.comment, that.comment) && Objects.equals(this.creationTime, that.creationTime) && Arrays.equals(this.extra, that.extra) && Objects.equals(this.modificationTime, that.modificationTime) && Objects.equals(this.lastAccessTime, that.lastAccessTime);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.comment);
        result = 31 * result + this.compressionMethod;
        result = 31 * result + Objects.hashCode(this.creationTime);
        result = 31 * result + Arrays.hashCode(this.extra);
        result = 31 * result + Objects.hashCode(this.modificationTime);
        result = 31 * result + Objects.hashCode(this.lastAccessTime);
        result = 31 * result + Long.hashCode(this.size);
        result = 31 * result + Long.hashCode(this.compressedSize);
        result = 31 * result + Long.hashCode(this.crc);
        return result;
    }
}

