/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ASiCContentDocumentFilter {
    private boolean mimetypeDocument;
    private boolean signedDocuments;
    private boolean signatureDocuments;
    private boolean timestampDocuments;
    private boolean evidenceRecordDocuments;
    private boolean manifestDocuments;
    private boolean archiveManifestDocuments;
    private boolean evidenceRecordManifestDocuments;
    private boolean unsupportedDocuments;
    private Collection<String> excludedFilenames;
    private Collection<String> includedFilenames;

    public void setMimetypeDocument(boolean mimetypeDocument) {
        this.mimetypeDocument = mimetypeDocument;
    }

    public void setSignedDocuments(boolean signedDocuments) {
        this.signedDocuments = signedDocuments;
    }

    public void setSignatureDocuments(boolean signatureDocuments) {
        this.signatureDocuments = signatureDocuments;
    }

    public void setTimestampDocuments(boolean timestampDocuments) {
        this.timestampDocuments = timestampDocuments;
    }

    public void setEvidenceRecordDocuments(boolean evidenceRecordDocuments) {
        this.evidenceRecordDocuments = evidenceRecordDocuments;
    }

    public void setManifestDocuments(boolean manifestDocuments) {
        this.manifestDocuments = manifestDocuments;
    }

    public void setArchiveManifestDocuments(boolean archiveManifestDocuments) {
        this.archiveManifestDocuments = archiveManifestDocuments;
    }

    public void setEvidenceRecordManifestDocuments(boolean evidenceRecordManifestDocuments) {
        this.evidenceRecordManifestDocuments = evidenceRecordManifestDocuments;
    }

    public void setUnsupportedDocuments(boolean unsupportedDocuments) {
        this.unsupportedDocuments = unsupportedDocuments;
    }

    public void setExcludedFilenames(Collection<String> excludedFilenames) {
        this.excludedFilenames = excludedFilenames;
    }

    public void setIncludedFilenames(Collection<String> includedFilenames) {
        this.includedFilenames = includedFilenames;
    }

    public List<DSSDocument> filter(ASiCContent asicContent) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (asicContent.getMimeTypeDocument() != null) {
            result.addAll(this.filterDocuments(Collections.singletonList(asicContent.getMimeTypeDocument()), this.mimetypeDocument));
        }
        result.addAll(this.filterDocuments(asicContent.getSignedDocuments(), this.signedDocuments));
        result.addAll(this.filterDocuments(asicContent.getSignatureDocuments(), this.signatureDocuments));
        result.addAll(this.filterDocuments(asicContent.getTimestampDocuments(), this.timestampDocuments));
        result.addAll(this.filterDocuments(asicContent.getEvidenceRecordDocuments(), this.evidenceRecordDocuments));
        result.addAll(this.filterDocuments(asicContent.getManifestDocuments(), this.manifestDocuments));
        result.addAll(this.filterDocuments(asicContent.getArchiveManifestDocuments(), this.archiveManifestDocuments));
        result.addAll(this.filterDocuments(asicContent.getEvidenceRecordManifestDocuments(), this.evidenceRecordManifestDocuments));
        result.addAll(this.filterDocuments(asicContent.getUnsupportedDocuments(), this.unsupportedDocuments));
        return result;
    }

    private Collection<DSSDocument> filterDocuments(Collection<DSSDocument> documents, boolean formatSupported) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (Utils.isCollectionNotEmpty(this.includedFilenames)) {
            documents.stream().filter((? super T d) -> this.includedFilenames.contains(d.getName())).forEach(result::add);
        }
        if (!formatSupported) {
            return result;
        }
        if (Utils.isCollectionEmpty(this.excludedFilenames)) {
            return documents;
        }
        return documents.stream().filter((? super T d) -> !result.contains(d) && !this.excludedFilenames.contains(d.getName())).collect(Collectors.toList());
    }
}

