/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilter;
import eu.europa.esig.dss.asic.common.evidencerecord.ZipContentEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.asic.common.extract.ASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilderFactory;
import java.util.List;
import java.util.Objects;

public class ASiCEvidenceRecordDigestBuilder
extends ZipContentEvidenceRecordDigestBuilder {
    private final ASiCContent asicContent;
    private ASiCContentDocumentFilter asicContentDocumentFilter;

    public ASiCEvidenceRecordDigestBuilder(DSSDocument asicContainer) throws IllegalInputException {
        this(asicContainer, DigestAlgorithm.SHA256);
    }

    public ASiCEvidenceRecordDigestBuilder(DSSDocument asicContainer, DigestAlgorithm digestAlgorithm) throws IllegalInputException {
        this(ASiCEvidenceRecordDigestBuilder.toASiCContent(asicContainer), digestAlgorithm);
    }

    private static ASiCContent toASiCContent(DSSDocument asicContainer) {
        try {
            ASiCContainerExtractor asicContainerExtractor = DefaultASiCContainerExtractor.fromDocument(asicContainer);
            return asicContainerExtractor.extract();
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unsupported ASiC or document type! Returned error : %s", e.getMessage()), e);
        }
    }

    public ASiCEvidenceRecordDigestBuilder(ASiCContent asicContent) {
        this(asicContent, DigestAlgorithm.SHA256);
    }

    public ASiCEvidenceRecordDigestBuilder(ASiCContent asicContent, DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
        this.asicContent = asicContent;
    }

    @Override
    public ASiCEvidenceRecordDigestBuilder setDataObjectDigestBuilderFactory(DataObjectDigestBuilderFactory dataObjectDigestBuilderFactory) {
        super.setDataObjectDigestBuilderFactory(dataObjectDigestBuilderFactory);
        return this;
    }

    public ASiCEvidenceRecordDigestBuilder setAsicContentDocumentFilter(ASiCContentDocumentFilter asicContentDocumentFilter) {
        this.asicContentDocumentFilter = asicContentDocumentFilter;
        return this;
    }

    @Override
    public List<Digest> buildDigestGroup() {
        this.assertConfigurationValid();
        List<DSSDocument> documents = this.getDocumentListToComputeDigest();
        return this.computeDigestForDocuments(documents);
    }

    @Override
    protected void assertConfigurationValid() {
        super.assertConfigurationValid();
        Objects.requireNonNull(this.asicContentDocumentFilter, "ASiCContentDocumentFilter shall be set to continue! Use ASiCContentDocumentFilterFactory to facilitate configuration.");
    }

    protected List<DSSDocument> getDocumentListToComputeDigest() {
        return this.asicContentDocumentFilter.filter(this.asicContent);
    }
}

