/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ASiCContainerEvidenceRecordParameters;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCEvidenceRecordFilenameFactory;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilterFactory;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCEvidenceRecordManifestBuilder;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCContentBuilder;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestParser;
import eu.europa.esig.dss.asic.common.validation.ASiCManifestValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.SignatureValidationAlerter;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASiCContainerEvidenceRecordBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractASiCContainerEvidenceRecordBuilder.class);
    protected final CertificateVerifier certificateVerifier;
    protected final ASiCEvidenceRecordFilenameFactory asicFilenameFactory;

    protected AbstractASiCContainerEvidenceRecordBuilder(CertificateVerifier certificateVerifier, ASiCEvidenceRecordFilenameFactory asicFilenameFactory) {
        this.certificateVerifier = certificateVerifier;
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public ASiCContent build(List<DSSDocument> documents, DSSDocument evidenceRecordDocument, ASiCContainerEvidenceRecordParameters parameters) {
        ASiCContent asicContent = this.initASiCContent(documents, parameters);
        this.assertASiCContentValid(asicContent, parameters);
        DSSDocument evidenceRecordManifest = this.getASiCEvidenceRecordManifest(parameters);
        ManifestFile manifestFile = this.parseManifestFile(evidenceRecordManifest, asicContent);
        this.assertManifestFileValid(manifestFile, asicContent);
        EvidenceRecord evidenceRecord = this.getEvidenceRecord(evidenceRecordDocument, manifestFile, asicContent);
        this.assertEvidenceRecordValid(evidenceRecord, manifestFile);
        List<DSSDocument> coveredDocuments = this.getDocumentsCoveredByEvidenceRecord(evidenceRecord, asicContent);
        this.assertSignedDataCovered(asicContent, DSSUtils.getDocumentNames(coveredDocuments));
        String evidenceRecordFilename = this.getEvidenceRecordFilename(evidenceRecord, manifestFile, asicContent);
        this.assertEvidenceRecordFilenameValid(evidenceRecordFilename, evidenceRecord.getEvidenceRecordType(), asicContent);
        evidenceRecordDocument.setName(evidenceRecordFilename);
        asicContent.getEvidenceRecordDocuments().add(evidenceRecordDocument);
        if (evidenceRecordManifest == null) {
            evidenceRecordManifest = this.buildEvidenceRecordManifest(asicContent, coveredDocuments, evidenceRecord.getOriginalDigestAlgorithm(), evidenceRecordFilename);
        }
        if (evidenceRecordManifest != null) {
            asicContent.getEvidenceRecordManifestDocuments().add(evidenceRecordManifest);
        }
        return ASiCUtils.ensureMimeTypeAndZipComment(asicContent, parameters);
    }

    protected ASiCContent initASiCContent(List<DSSDocument> documents, ASiCParameters parameters) {
        return this.getASiCContentBuilder().build(documents, parameters.getContainerType());
    }

    protected abstract AbstractASiCContentBuilder getASiCContentBuilder();

    protected DSSDocument getASiCEvidenceRecordManifest(ASiCContainerEvidenceRecordParameters parameters) {
        if (parameters.getAsicEvidenceRecordManifest() != null) {
            if (ASiCContainerType.ASiC_E == parameters.getContainerType()) {
                return parameters.getAsicEvidenceRecordManifest();
            }
            LOG.info("ASiC-S container does not require an ASiCEvidenceRecordManifest file. The parameter is skipped.");
        }
        return null;
    }

    protected EvidenceRecord getEvidenceRecord(DSSDocument evidenceRecordDocument, ManifestFile manifestFile, ASiCContent asicContent) {
        try {
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument(evidenceRecordDocument);
            evidenceRecordAnalyzer.setManifestFile(manifestFile);
            evidenceRecordAnalyzer.setDetachedContents(asicContent.getAllDocuments());
            evidenceRecordAnalyzer.setEvidenceRecordOrigin(EvidenceRecordOrigin.CONTAINER);
            return evidenceRecordAnalyzer.getEvidenceRecord();
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unable to build evidence record document. Reason : %s", e.getMessage()));
        }
    }

    protected ManifestFile parseManifestFile(DSSDocument evidenceRecordManifest, ASiCContent asicContent) {
        if (evidenceRecordManifest == null) {
            return null;
        }
        if (evidenceRecordManifest.getName() != null) {
            this.assertASiCEvidenceRecordManifestValid(evidenceRecordManifest.getName(), asicContent);
        } else {
            evidenceRecordManifest.setName(this.asicFilenameFactory.getEvidenceRecordManifestFilename(asicContent));
        }
        ManifestFile manifestFile = ASiCManifestParser.getManifestFile(evidenceRecordManifest);
        if (manifestFile == null) {
            throw new IllegalInputException("Unable to parse the provided ASiCEvidenceRecordManifest document! More detail in logs.");
        }
        manifestFile.setManifestType(ASiCManifestTypeEnum.EVIDENCE_RECORD);
        return manifestFile;
    }

    protected void assertASiCEvidenceRecordManifestValid(String manifestFilename, ASiCContent asicContent) {
        List<String> asicDocumentNames = DSSUtils.getDocumentNames(asicContent.getAllDocuments());
        if (asicDocumentNames.contains(manifestFilename)) {
            throw new IllegalInputException(String.format("The manifest filename '%s' is already present within the ASiC container!", manifestFilename));
        }
        if (!ASiCUtils.isEvidenceRecordManifest(manifestFilename)) {
            throw new IllegalArgumentException(String.format("The manifest filename '%s' is not compliant to the ASiCEvidenceRecordManifest filename convention!", manifestFilename));
        }
    }

    protected void assertManifestFileValid(ManifestFile manifestFile, ASiCContent asicContent) {
        if (manifestFile == null) {
            return;
        }
        ASiCManifestValidator manifestValidator = new ASiCManifestValidator(manifestFile, asicContent.getAllDocuments());
        manifestValidator.validateEntries();
        for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
            if (manifestEntry.isFound() && manifestEntry.isIntact()) continue;
            throw new IllegalInputException(String.format("The manifest entry '%s' was not found or digest does not intact! Please provide a valid ASiCEvidenceRecordManifest document.", manifestEntry.getUri()));
        }
        List<String> manifestCoveredFilenames = manifestFile.getEntries().stream().map(ManifestEntry::getDocumentName).collect(Collectors.toList());
        this.assertSignedDataCovered(asicContent, manifestCoveredFilenames);
    }

    private List<DSSDocument> getDocumentsCoveredByEvidenceRecord(EvidenceRecord evidenceRecord, ASiCContent asicContent) {
        ArrayList<DSSDocument> coveredDocuments = new ArrayList<DSSDocument>();
        List<DSSDocument> allDocuments = asicContent.getAllDocuments();
        List<String> allDocumentFilenames = DSSUtils.getDocumentNames(allDocuments);
        for (ReferenceValidation referenceValidation : evidenceRecord.getReferenceValidation()) {
            String documentName = referenceValidation.getDocumentName();
            if (!allDocumentFilenames.contains(referenceValidation.getDocumentName())) continue;
            coveredDocuments.add(DSSUtils.getDocumentWithName(allDocuments, documentName));
        }
        return coveredDocuments;
    }

    protected String getEvidenceRecordFilename(EvidenceRecord evidenceRecord, ManifestFile manifestFile, ASiCContent asicContent) {
        if (manifestFile != null) {
            return manifestFile.getSignatureFilename();
        }
        return this.asicFilenameFactory.getEvidenceRecordFilename(asicContent, evidenceRecord.getEvidenceRecordType());
    }

    protected DSSDocument buildEvidenceRecordManifest(ASiCContent asicContent, List<DSSDocument> coveredDocuments, DigestAlgorithm digestAlgorithm, String evidenceRecordFilename) {
        if (ASiCContainerType.ASiC_E == asicContent.getContainerType()) {
            return new ASiCEvidenceRecordManifestBuilder(asicContent, digestAlgorithm, evidenceRecordFilename).setAsicContentDocumentFilter(ASiCContentDocumentFilterFactory.allowedFilenamesFilter(this.getDocumentNames(coveredDocuments))).setEvidenceRecordFilenameFactory(this.asicFilenameFactory).build();
        }
        return null;
    }

    private String[] getDocumentNames(List<DSSDocument> coveredDocuments) {
        return DSSUtils.getDocumentNames(coveredDocuments).toArray(new String[0]);
    }

    protected void assertASiCContentValid(ASiCContent asicContent, ASiCParameters parameters) {
        ASiCContainerType currentContainerType = asicContent.getContainerType();
        boolean asice = ASiCUtils.isASiCE(parameters);
        if (!asice || !ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                if (Utils.collectionSize(asicContent.getSignedDocuments()) != 1) {
                    throw new IllegalArgumentException("Only one original document is expected for the ASiC-S container type! If required, please create a 'package.zip' and provide it directly as a parameter. Otherwise, please switch to the ASiC-E type.");
                }
                if (Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments()) || Utils.isCollectionNotEmpty(asicContent.getEvidenceRecordDocuments())) {
                    throw new IllegalInputException("Only one of the signature, timestamp or evidence record document types is allowed within an ASiC-S container type!");
                }
            } else {
                throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", new Object[]{currentContainerType, parameters.getContainerType()}));
            }
        }
    }

    protected void assertSignedDataCovered(ASiCContent asicContent, List<String> coveredDocumentFilenames) {
        List<String> signedDocumentNames = DSSUtils.getDocumentNames(asicContent.getSignedDocuments());
        for (String signedDocumentFilename : signedDocumentNames) {
            if (coveredDocumentFilenames.contains(signedDocumentFilename)) continue;
            throw new IllegalInputException(String.format("The original document with name '%s' is not covered by the evidence record!", signedDocumentFilename));
        }
        for (String documentName : coveredDocumentFilenames) {
            DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest(asicContent.getAllManifestDocuments(), documentName);
            this.assertManifestSignedDataCoveredRecursively(linkedManifest, coveredDocumentFilenames, asicContent);
        }
    }

    private void assertManifestSignedDataCoveredRecursively(DSSDocument manifestDocument, List<String> coveredDocumentNames, ASiCContent asicContent) {
        if (manifestDocument != null) {
            if (!coveredDocumentNames.contains(manifestDocument.getName())) {
                throw new IllegalInputException(String.format("Digest of a signed ASiC Manifest with name '%s' has not been found in the evidence record's covered objects!", manifestDocument.getName()));
            }
            ManifestFile manifestFile = ASiCManifestParser.getManifestFile(manifestDocument);
            if (manifestFile != null) {
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (!coveredDocumentNames.contains(entry.getUri())) {
                        throw new IllegalInputException(String.format("Digest for a document referenced from a covered ASiC Manifest with name '%s' has not been found in the evidence record's covered objects!", entry.getUri()));
                    }
                    DSSDocument linkedManifest = ASiCManifestParser.getLinkedManifest(asicContent.getAllManifestDocuments(), entry.getUri());
                    this.assertManifestSignedDataCoveredRecursively(linkedManifest, coveredDocumentNames, asicContent);
                }
            }
        }
    }

    protected void assertEvidenceRecordValid(EvidenceRecord evidenceRecord, ManifestFile manifestFile) {
        if (manifestFile != null) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (manifestEntry.getDigest() == null || evidenceRecord.getOriginalDigestAlgorithm() == manifestEntry.getDigest().getAlgorithm()) continue;
                throw new IllegalInputException(String.format("Digest algorithm '%s' found in the ASiCEvidenceRecordManifest document does not correspond to the Digest Algorithm '%s' used for the first data object group of evidence record generation!", manifestEntry.getDigest().getAlgorithm(), evidenceRecord.getOriginalDigestAlgorithm()));
            }
        }
        String errorMessage = "The digest covered by the evidence record do not correspond to the digest computed on the provided content!";
        boolean signedDataFound = false;
        for (ReferenceValidation referenceValidation : evidenceRecord.getReferenceValidation()) {
            if (DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == referenceValidation.getType()) continue;
            if (!referenceValidation.isIntact()) {
                if (referenceValidation.getDocumentName() != null) {
                    throw new IllegalInputException(String.format("The digest of document '%s' has not been found within the manifest file or/and evidence record!", referenceValidation.getDocumentName()));
                }
                throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the provided content!");
            }
            signedDataFound = true;
        }
        if (!signedDataFound) {
            throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the provided content!");
        }
        this.validateTimestamps(evidenceRecord);
    }

    protected void assertEvidenceRecordFilenameValid(String evidenceRecordFilename, EvidenceRecordTypeEnum evidenceRecordType, ASiCContent asicContent) {
        List<String> asicDocumentNames = DSSUtils.getDocumentNames(asicContent.getAllDocuments());
        if (asicDocumentNames.contains(evidenceRecordFilename)) {
            throw new IllegalInputException(String.format("The evidence record filename '%s' is already present within the ASiC container!", evidenceRecordFilename));
        }
    }

    private void validateTimestamps(EvidenceRecord evidenceRecord) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.addDocumentCertificateSource(evidenceRecord.getCertificateSource());
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        validationContext.validate();
        SignatureValidationAlerter signatureValidationAlerter = new SignatureValidationAlerter(validationContext);
        signatureValidationAlerter.setSigningOperation(SigningOperation.ADD_EVIDENCE_RECORD);
        signatureValidationAlerter.assertAllTimestampsValid();
    }
}

