/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;

public abstract class AbstractASiCDataToSignHelperBuilder {
    protected AbstractASiCDataToSignHelperBuilder() {
    }

    protected DSSDocument getASiCSSignedDocument(List<DSSDocument> filesToBeSigned, Date signingDate) {
        if (Utils.collectionSize(filesToBeSigned) == 1) {
            return filesToBeSigned.iterator().next();
        }
        if (Utils.collectionSize(filesToBeSigned) > 1) {
            return this.createPackageZip(filesToBeSigned, signingDate);
        }
        throw new IllegalArgumentException("At least one file to be signed shall be provided!");
    }

    protected DSSDocument createPackageZip(List<DSSDocument> documents, Date signingDate) {
        DSSDocument packageZip = ZipUtils.getInstance().createZipArchive(documents, signingDate, null);
        ASiCContent asicContent = new ASiCContent();
        asicContent.setContainerDocuments(documents);
        packageZip.setName(this.getDataPackageName(asicContent));
        packageZip.setMimeType(MimeTypeEnum.ZIP);
        return packageZip;
    }

    protected abstract String getDataPackageName(ASiCContent var1);
}

