/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.merge;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.merge.DefaultContainerMerger;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESFormatDetector;
import eu.europa.esig.dss.asic.xades.extract.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.asic.xades.signature.DefaultASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.Objects;

public abstract class AbstractASiCWithXAdESContainerMerger
extends DefaultContainerMerger {
    protected ASiCWithXAdESFilenameFactory asicFilenameFactory = new DefaultASiCWithXAdESFilenameFactory();

    AbstractASiCWithXAdESContainerMerger() {
    }

    protected AbstractASiCWithXAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    protected AbstractASiCWithXAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    public void setAsicFilenameFactory(ASiCWithXAdESFilenameFactory asicFilenameFactory) {
        Objects.requireNonNull(asicFilenameFactory, "ASiCWithXAdESFilenameFactory cannot be null!");
        this.asicFilenameFactory = asicFilenameFactory;
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return new ASiCWithXAdESFormatDetector().isSupportedZip(container);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return new ASiCWithXAdESFormatDetector().isSupportedZip(asicContent);
    }

    @Override
    protected DefaultASiCContainerExtractor getContainerExtractor(DSSDocument container) {
        return new ASiCWithXAdESContainerExtractor(container);
    }
}

