/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CAdESAttributeIdentifier;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.identifier.SignatureAttributeIdentifier;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESAttribute
implements SignatureAttribute {
    private static final long serialVersionUID = 7020534361457301562L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESAttribute.class);
    private final Attribute attribute;
    private final Integer order;
    protected CAdESAttributeIdentifier identifier;

    CAdESAttribute(Attribute attribute, Integer order) {
        this.attribute = attribute;
        this.order = order;
    }

    public ASN1ObjectIdentifier getASN1Oid() {
        return this.attribute.getAttrType();
    }

    public ASN1Set getAttrValues() {
        return this.attribute.getAttrValues();
    }

    public ASN1Encodable getASN1Object() {
        return DSSASN1Utils.getAsn1Encodable(this.attribute);
    }

    public boolean isTimeStampToken() {
        return CAdESUtils.getTimestampOids().contains(this.getASN1Oid());
    }

    public TimestampType getTimestampTokenType() {
        if (this.isTimeStampToken()) {
            return CAdESUtils.getTimestampTypeByOid(this.getASN1Oid());
        }
        return null;
    }

    public TimeStampToken toTimeStampToken() {
        if (this.isTimeStampToken()) {
            try {
                return CAdESUtils.getTimeStampToken(this.attribute);
            }
            catch (Exception e) {
                LOG.warn("Unable to build a timestamp token from the attribute [{}] : {}", (Object)this, (Object)e.getMessage());
            }
        } else {
            LOG.warn("The given attribute [{}] is not a timestamp! Unable to build a TimeStampToken.", (Object)this);
        }
        return null;
    }

    public boolean isEvidenceRecord() {
        return CAdESUtils.getEvidenceRecordOids().contains(this.getASN1Oid());
    }

    public EvidenceRecord toEvidenceRecord() {
        if (this.isEvidenceRecord()) {
            try {
                return EvidenceRecord.getInstance(this.getASN1Object());
            }
            catch (Exception e) {
                LOG.warn("Unable to build an evidence record from the attribute [{}] : {}", (Object)this, (Object)e.getMessage());
            }
        } else {
            LOG.warn("The given attribute [{}] is not an evidence record! Unable to build an EvidenceRecord.", (Object)this);
        }
        return null;
    }

    protected Integer getOrder() {
        return this.order;
    }

    @Override
    public SignatureAttributeIdentifier getIdentifier() {
        if (this.identifier == null) {
            this.identifier = CAdESAttributeIdentifier.build(this.attribute, this.order);
        }
        return this.identifier;
    }

    public String toString() {
        ASN1ObjectIdentifier asn1Oid = this.getASN1Oid();
        if (asn1Oid != null) {
            return asn1Oid.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAdESAttribute that = (CAdESAttribute)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier());
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }
}

