/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.timestamp;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.evidencerecord.CAdESEmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignedAttributes;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampMessageDigestBuilder;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EvidenceRecordIncorporationType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureProperties;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.spi.x509.CMSCRLSource;
import eu.europa.esig.dss.spi.x509.CMSCertificateSource;
import eu.europa.esig.dss.spi.x509.CMSOCSPSource;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampSource
extends SignatureTimestampSource<CAdESSignature, CAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampSource.class);

    public CAdESTimestampSource(CAdESSignature signature) {
        super(signature);
    }

    @Override
    protected CAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(DigestAlgorithm digestAlgorithm) {
        return new CAdESTimestampMessageDigestBuilder((CAdESSignature)this.signature, digestAlgorithm);
    }

    @Override
    protected CAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(TimestampToken timestampToken) {
        return new CAdESTimestampMessageDigestBuilder((CAdESSignature)this.signature, this.certificateSource, timestampToken);
    }

    @Override
    protected SignatureProperties<CAdESAttribute> buildSignedSignatureProperties() {
        return CAdESSignedAttributes.build(((CAdESSignature)this.signature).getSignerInformation());
    }

    @Override
    protected SignatureProperties<CAdESAttribute> buildUnsignedSignatureProperties() {
        return CAdESUnsignedAttributes.build(((CAdESSignature)this.signature).getSignerInformation());
    }

    @Override
    protected boolean isContentTimestamp(CAdESAttribute signedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals(signedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAllDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isIndividualDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isSignatureTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certificateRefs.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeCertificateRefsOid.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationRefs.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeRevocationRefsOid.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certValues.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationValues.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttrAuthoritiesCertValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isAttributeRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestampV2(unsignedAttribute) || this.isArchiveTimestampV3(unsignedAttribute);
    }

    private boolean isArchiveTimestampV2(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV2.equals(unsignedAttribute.getASN1Oid());
    }

    private boolean isArchiveTimestampV3(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV3.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isTimeStampValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isAnyValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isValidationDataReferences(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isCounterSignature(CAdESAttribute unsignedAttribute) {
        return CMSAttributes.counterSignature.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isSignaturePolicyStore(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_sigPolicyStore.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isEvidenceRecord(CAdESAttribute unsignedAttribute) {
        return unsignedAttribute.isEvidenceRecord();
    }

    @Override
    protected TimestampToken makeTimestampToken(CAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimeStampToken timestamp = signatureAttribute.toTimeStampToken();
        if (timestamp == null) {
            return null;
        }
        SignatureTimestampIdentifierBuilder identifierBuilder = new SignatureTimestampIdentifierBuilder(timestamp).setSignature(this.signature).setAttribute(signatureAttribute).setOrderOfAttribute(this.getAttributeOrder(signatureAttribute));
        return new TimestampToken(timestamp, timestampType, references, (TimestampIdentifierBuilder)identifierBuilder);
    }

    @Override
    protected List<EvidenceRecord> makeEvidenceRecords(CAdESAttribute unsignedAttribute, List<TimestampedReference> references) {
        ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
        ASN1Set attrValues = unsignedAttribute.getAttrValues();
        for (int i = 0; i < attrValues.size(); ++i) {
            EvidenceRecord evidenceRecord = this.createEvidenceRecord(unsignedAttribute, attrValues.getObjectAt(i), i);
            if (evidenceRecord == null) continue;
            result.add(evidenceRecord);
        }
        return result;
    }

    private EvidenceRecord createEvidenceRecord(CAdESAttribute unsignedAttribute, ASN1Encodable erASN1Encodable, int orderWithinAttribute) {
        try {
            byte[] erEncoded = DSSASN1Utils.getDEREncoded(erASN1Encodable);
            InMemoryDocument erDocument = new InMemoryDocument(erEncoded);
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument(erDocument);
            evidenceRecordAnalyzer.setEvidenceRecordOrigin(EvidenceRecordOrigin.SIGNATURE);
            EvidenceRecordIncorporationType incorporationType = CAdESUtils.getEvidenceRecordIncorporationType(unsignedAttribute.getASN1Oid());
            evidenceRecordAnalyzer.setEvidenceRecordIncorporationType(incorporationType);
            CAdESEmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = new CAdESEmbeddedEvidenceRecordHelper((CAdESSignature)this.signature, unsignedAttribute);
            if (EvidenceRecordIncorporationType.EXTERNAL_EVIDENCE_RECORD == incorporationType) {
                if (Utils.collectionSize(((CAdESSignature)this.signature).getDetachedContents()) == 1) {
                    embeddedEvidenceRecordHelper.setDetachedContents(((CAdESSignature)this.signature).getDetachedContents());
                } else {
                    LOG.warn("Detached document has not been provided to the validation of an external-evidence-record!");
                }
            }
            embeddedEvidenceRecordHelper.setOrderOfAttribute(this.getAttributeOrder(unsignedAttribute));
            embeddedEvidenceRecordHelper.setOrderWithinAttribute(orderWithinAttribute);
            evidenceRecordAnalyzer.setEmbeddedEvidenceRecordHelper(embeddedEvidenceRecordHelper);
            return evidenceRecordAnalyzer.getEvidenceRecord();
        }
        catch (Exception e) {
            LOG.warn("Unable to build an embedded evidence record. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    protected void incorporateArchiveTimestampReferences(TimestampToken timestampToken, List<TimestampToken> previousTimestamps) {
        if (this.isArchiveTimestampV2(timestampToken)) {
            super.incorporateArchiveTimestampReferences(timestampToken, previousTimestamps);
        }
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        this.addReferences(timestampedReferences, this.getSignatureTimestampReferences());
        ASN1Sequence atsHashIndex = CAdESUtils.getAtsHashIndex(timestampToken.getUnsignedAttributes());
        if (atsHashIndex != null) {
            DigestAlgorithm digestAlgorithm = this.getHashIndexDigestAlgorithm(atsHashIndex);
            ASN1Sequence certsHashIndex = CAdESUtils.getCertificatesHashIndex(atsHashIndex);
            ASN1Sequence crlHashIndex = CAdESUtils.getCRLHashIndex(atsHashIndex);
            this.addReferences(timestampedReferences, this.getSignedDataCertificateReferences(certsHashIndex, digestAlgorithm));
            this.addReferences(timestampedReferences, this.getSignedDataRevocationReferences(crlHashIndex, digestAlgorithm));
            ASN1Sequence unsignedAttrsHashIndex = CAdESUtils.getUnsignedAttributesHashIndex(atsHashIndex);
            this.addReferences(timestampedReferences, this.getUnsignedAttributesReferences(unsignedAttrsHashIndex, digestAlgorithm, previousTimestamps));
        }
        timestampToken.getTimestampedReferences().addAll(timestampedReferences);
    }

    @Override
    protected List<TimestampedReference> getArchiveTimestampReferences(List<TimestampToken> previousTimestamps) {
        List<TimestampedReference> timestampedReferences = super.getArchiveTimestampReferences(previousTimestamps);
        this.addReferences(timestampedReferences, this.getSignatureSignedDataReferences());
        return timestampedReferences;
    }

    private boolean isArchiveTimestampV2(TimestampToken timestampToken) {
        return ArchiveTimestampType.CAdES_V2.equals((Object)timestampToken.getArchiveTimestampType()) || ArchiveTimestampType.CAdES.equals((Object)timestampToken.getArchiveTimestampType());
    }

    private List<TimestampedReference> getSignedDataCertificateReferences(ASN1Sequence certsHashIndex, DigestAlgorithm digestAlgorithm) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        SignatureCertificateSource signatureCertificateSource = ((CAdESSignature)this.signature).getCertificateSource();
        if (signatureCertificateSource instanceof CMSCertificateSource) {
            List<DEROctetString> certsHashList = DSSASN1Utils.getDEROctetStrings(certsHashIndex);
            for (CertificateToken certificate : signatureCertificateSource.getSignedDataCertificates()) {
                if (this.isDigestValuePresent(certificate.getDigest(digestAlgorithm), certsHashList)) {
                    this.addReference(references, certificate.getDSSId(), TimestampedObjectType.CERTIFICATE);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The certificate with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp has been incorporated!", (Object)certificate.getDSSIdAsString());
            }
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataRevocationReferences(ASN1Sequence crlsHashIndex, DigestAlgorithm digestAlgorithm) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<DEROctetString> crlsHashList = DSSASN1Utils.getDEROctetStrings(crlsHashIndex);
        this.addReferences(references, this.createReferencesForCRLBinaries(this.getSignedDataCRLBinaries(crlsHashList, digestAlgorithm)));
        this.addReferences(references, this.createReferencesForOCSPBinaries(this.getSignedDataOCSPResponseBinaries(crlsHashList, digestAlgorithm), this.certificateSource));
        return references;
    }

    private List<CRLBinary> getSignedDataCRLBinaries(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        ArrayList<CRLBinary> crlBinaries = new ArrayList<CRLBinary>();
        OfflineCRLSource signatureCRLSource = ((CAdESSignature)this.signature).getCRLSource();
        if (signatureCRLSource instanceof CMSCRLSource) {
            CMSCRLSource cmsCRLSource = (CMSCRLSource)signatureCRLSource;
            for (EncapsulatedRevocationTokenIdentifier crlIdentifier : cmsCRLSource.getCMSSignedDataRevocationBinaries()) {
                CRLBinary crlBinary = (CRLBinary)crlIdentifier;
                if (this.isDigestValuePresent(crlBinary.getDigestValue(digestAlgorithm), crlsHashList)) {
                    crlBinaries.add(crlBinary);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The CRL Token with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)crlBinary.asXmlId());
            }
        }
        return crlBinaries;
    }

    private List<OCSPResponseBinary> getSignedDataOCSPResponseBinaries(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        ArrayList<OCSPResponseBinary> ocspBinaries = new ArrayList<OCSPResponseBinary>();
        OfflineOCSPSource signatureOCSPSource = ((CAdESSignature)this.signature).getOCSPSource();
        if (signatureOCSPSource instanceof CMSOCSPSource) {
            CMSOCSPSource cmsOCSPSource = (CMSOCSPSource)signatureOCSPSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsOCSPSource.getCMSSignedDataRevocationBinaries()) {
                OCSPResponseBinary binary = (OCSPResponseBinary)token;
                if (this.isOCSPResponsePresent(binary, crlsHashList, digestAlgorithm)) {
                    ocspBinaries.add(binary);
                    continue;
                }
                LOG.warn("The OCSP Token with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)binary.asXmlId());
            }
        }
        return ocspBinaries;
    }

    private boolean isOCSPResponsePresent(OCSPResponseBinary binary, List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        ASN1ObjectIdentifier objectIdentifier = binary.getAsn1ObjectIdentifier();
        if (OCSPObjectIdentifiers.id_pkix_ocsp_basic.equals(binary.getAsn1ObjectIdentifier())) {
            return this.isOCSPDigestValueMatch(binary.getBasicOCSPRespContent(), objectIdentifier, crlsHashList, digestAlgorithm);
        }
        if (objectIdentifier == null) {
            objectIdentifier = OCSPObjectIdentifiers.id_pkix_ocsp_response;
        }
        return this.isOCSPDigestValueMatch(binary.getBinaries(), objectIdentifier, crlsHashList, digestAlgorithm) || this.isOCSPDigestValueMatch(binary.getBasicOCSPRespContent(), objectIdentifier, crlsHashList, digestAlgorithm);
    }

    private boolean isOCSPDigestValueMatch(byte[] binaries, ASN1ObjectIdentifier objectIdentifier, List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        byte[] encoded = CAdESUtils.getSignedDataEncodedOCSPResponse(binaries, objectIdentifier);
        return this.isDigestValuePresent(DSSUtils.digest(digestAlgorithm, encoded), crlsHashList);
    }

    private List<TimestampedReference> getUnsignedAttributesReferences(ASN1Sequence unsignedAttrsHashIndex, DigestAlgorithm digestAlgorithm, List<TimestampToken> previousTimestamps) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<DEROctetString> timestampUnsignedAttributesHashesList = DSSASN1Utils.getDEROctetStrings(unsignedAttrsHashIndex);
        SignatureProperties unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        for (CAdESAttribute unsignedAttribute : unsignedSignatureProperties.getAttributes()) {
            List<byte[]> octets = CAdESUtils.getATSHashIndexV3OctetString(unsignedAttribute.getASN1Oid(), unsignedAttribute.getAttrValues());
            for (byte[] bytes : octets) {
                byte[] digest = DSSUtils.digest(digestAlgorithm, bytes);
                DEROctetString derDigest = new DEROctetString(digest);
                if (!timestampUnsignedAttributesHashesList.contains(derDigest)) continue;
                this.addReferences(references, this.getReferencesFromUnsignedProperty(unsignedAttribute, previousTimestamps));
            }
        }
        return references;
    }

    private List<TimestampedReference> getReferencesFromUnsignedProperty(CAdESAttribute unsignedAttribute, List<TimestampToken> previousTimestamps) {
        if (unsignedAttribute.isTimeStampToken()) {
            List<TimestampedReference> references = this.getReferencesFromMatchingTimestamp(unsignedAttribute, previousTimestamps);
            if (Utils.isCollectionEmpty(references)) {
                LOG.warn("The timestamp order is broken! Unable to find a covered timestamp.");
            }
            return references;
        }
        if (this.isCompleteCertificateRef(unsignedAttribute) || this.isAttributeCertificateRef(unsignedAttribute)) {
            return this.getTimestampedCertificateRefs(unsignedAttribute);
        }
        if (this.isCompleteRevocationRef(unsignedAttribute) || this.isAttributeRevocationRef(unsignedAttribute)) {
            return this.getTimestampedRevocationRefs(unsignedAttribute);
        }
        if (this.isCertificateValues(unsignedAttribute)) {
            return this.getTimestampedCertificateValues(unsignedAttribute);
        }
        if (this.isRevocationValues(unsignedAttribute)) {
            return this.getTimestampedRevocationValues(unsignedAttribute);
        }
        if (this.isCounterSignature(unsignedAttribute)) {
            List<AdvancedSignature> counterSignatures = this.getCounterSignatures(unsignedAttribute);
            return this.getCounterSignaturesReferences(counterSignatures);
        }
        LOG.warn("Unable to find an unsigned attribute with the digest from ats-hash-index-v3");
        return Collections.emptyList();
    }

    private List<TimestampedReference> getReferencesFromMatchingTimestamp(CAdESAttribute unsignedAttribute, List<TimestampToken> previousTimestamps) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        byte[] derEncoded = DSSASN1Utils.getDEREncoded(asn1Object);
        for (TimestampToken timestampToken : previousTimestamps) {
            if (!Arrays.equals(derEncoded, timestampToken.getEncoded())) continue;
            return this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        OfflineOCSPSource signatureOCSPSource;
        OfflineCRLSource signatureCRLSource;
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        SignatureCertificateSource signatureCertificateSource = ((CAdESSignature)this.signature).getCertificateSource();
        if (signatureCertificateSource instanceof CMSCertificateSource) {
            this.addReferences(references, this.createReferencesForCertificates(signatureCertificateSource.getSignedDataCertificates()));
        }
        if ((signatureCRLSource = ((CAdESSignature)this.signature).getCRLSource()) instanceof CMSCRLSource) {
            this.addReferences(references, this.createReferencesForCRLBinaries(signatureCRLSource.getCMSSignedDataRevocationBinaries()));
        }
        if ((signatureOCSPSource = ((CAdESSignature)this.signature).getOCSPSource()) instanceof CMSOCSPSource) {
            this.addReferences(references, this.createReferencesForOCSPBinaries(signatureOCSPSource.getCMSSignedDataRevocationBinaries(), this.certificateSource));
        }
        return references;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(ASN1Sequence atsHashIndex) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier(atsHashIndex);
        return algorithmIdentifier != null ? DigestAlgorithm.forOID(algorithmIdentifier.getAlgorithm().getId()) : CAdESUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private boolean isDigestValuePresent(byte[] digestValue, List<DEROctetString> hashList) {
        return hashList.contains(new DEROctetString(digestValue));
    }

    @Override
    protected List<CertificateRef> getCertificateRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            OtherCertID otherCertId = OtherCertID.getInstance(seq.getObjectAt(ii));
            certRefs.add(DSSASN1Utils.getCertificateRef(otherCertId));
        }
        return certRefs;
    }

    @Override
    protected List<CRLRef> getCRLRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> refs = new ArrayList<CRLRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            CrlOcspRef otherRefId = CrlOcspRef.getInstance(seq.getObjectAt(ii));
            CrlListID otherCrlIds = otherRefId.getCrlids();
            if (otherCrlIds == null) continue;
            for (CrlValidatedID id : otherCrlIds.getCrls()) {
                refs.add(new CRLRef(id));
            }
        }
        return refs;
    }

    @Override
    protected List<OCSPRef> getOCSPRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> refs = new ArrayList<OCSPRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int i = 0; i < seq.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance(seq.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                refs.add(new OCSPRef(ocspResponsesID));
            }
        }
        return refs;
    }

    @Override
    protected List<Identifier> getEncapsulatedCertificateIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            try {
                Certificate cs = Certificate.getInstance(seq.getObjectAt(ii));
                CertificateToken certificateToken = DSSUtils.loadCertificate(cs.getEncoded());
                certificateIdentifiers.add(certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    @Override
    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(CAdESAttribute unsignedAttribute) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues(asn1Object);
        if (revocationValues != null) {
            return this.buildCRLIdentifiers(revocationValues.getCrlVals());
        }
        return Collections.emptyList();
    }

    protected List<CRLBinary> buildCRLIdentifiers(CertificateList ... crlVals) {
        ArrayList<CRLBinary> crlBinaryIdentifiers = new ArrayList<CRLBinary>();
        if (Utils.isArrayNotEmpty(crlVals)) {
            for (CertificateList revValue : crlVals) {
                try {
                    crlBinaryIdentifiers.add(CRLUtils.buildCRLBinary(revValue.getEncoded()));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse CRL binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return crlBinaryIdentifiers;
    }

    @Override
    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(CAdESAttribute unsignedAttribute) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues(asn1Object);
        if (revocationValues != null) {
            return this.buildOCSPIdentifiers(DSSASN1Utils.toBasicOCSPResps(revocationValues.getOcspVals()));
        }
        return Collections.emptyList();
    }

    protected List<OCSPResponseBinary> buildOCSPIdentifiers(BasicOCSPResp ... ocspVals) {
        ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
        if (Utils.isArrayNotEmpty(ocspVals)) {
            for (BasicOCSPResp basicOCSPResp : ocspVals) {
                try {
                    ocspIdentifiers.add(OCSPResponseBinary.build(basicOCSPResp));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse OCSP response binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return ocspIdentifiers;
    }

    @Override
    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        if (OID.id_aa_ets_archiveTimestampV2.equals(unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V2;
        }
        if (OID.id_aa_ets_archiveTimestampV3.equals(unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V3;
        }
        return ArchiveTimestampType.CAdES;
    }

    @Override
    protected List<AdvancedSignature> getCounterSignatures(CAdESAttribute unsignedAttribute) {
        ArrayList<AdvancedSignature> cadesResult = new ArrayList<AdvancedSignature>();
        List<AdvancedSignature> allCounterSignatures = ((CAdESSignature)this.signature).getCounterSignatures();
        ASN1Set attrValues = unsignedAttribute.getAttrValues();
        Enumeration en = attrValues.getObjects();
        while (en.hasMoreElements()) {
            SignerInfo si = SignerInfo.getInstance(en.nextElement());
            byte[] encodedSI = DSSASN1Utils.getDEREncoded(si);
            for (AdvancedSignature counterSignature : allCounterSignatures) {
                CAdESSignature cadesCounterSignature = (CAdESSignature)counterSignature;
                SignerInfo signerInfo = cadesCounterSignature.getSignerInformation().toASN1Structure();
                byte[] encodedSignerInfo = DSSASN1Utils.getDEREncoded(signerInfo);
                if (!Arrays.equals(encodedSI, encodedSignerInfo)) continue;
                cadesResult.add(counterSignature);
            }
        }
        return cadesResult;
    }

    @Override
    protected List<TimestampedReference> getCounterSignatureReferences(AdvancedSignature counterSignature) {
        ArrayList<TimestampedReference> counterSigReferences = new ArrayList<TimestampedReference>();
        counterSigReferences.add(new TimestampedReference(counterSignature.getId(), TimestampedObjectType.SIGNATURE));
        List<CertificateRef> signingCertificateRefs = counterSignature.getCertificateSource().getSigningCertificateRefs();
        this.addReferences(counterSigReferences, this.createReferencesForCertificateRefs(signingCertificateRefs, counterSignature.getCertificateSource(), this.certificateSource));
        TimestampSource counterSignatureTimestampSource = counterSignature.getTimestampSource();
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getSignerDataReferences());
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getUnsignedPropertiesReferences());
        this.addReferences(counterSigReferences, this.getEncapsulatedReferencesFromTimestamps(counterSignatureTimestampSource.getAllTimestamps()));
        return counterSigReferences;
    }
}

