/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.MessageType;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.jaxb.object.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedReportMessageCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DetailedReportMessageCollector.class);
    private final DetailedReport detailedReport;

    DetailedReportMessageCollector(DetailedReport detailedReport) {
        Objects.requireNonNull(detailedReport, "DetailedReport cannot be null!");
        this.detailedReport = detailedReport;
    }

    List<Message> getAdESValidationErrors(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.ERROR, tokenId);
    }

    List<Message> getAdESValidationWarnings(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.WARN, tokenId);
    }

    List<Message> getAdESValidationInfos(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.INFO, tokenId);
    }

    List<Message> getQualificationErrors(String tokenId) {
        return this.collectQualificationMessages(MessageType.ERROR, tokenId);
    }

    List<Message> getQualificationWarnings(String tokenId) {
        return this.collectQualificationMessages(MessageType.WARN, tokenId);
    }

    List<Message> getQualificationInfos(String tokenId) {
        return this.collectQualificationMessages(MessageType.INFO, tokenId);
    }

    List<Message> getCertificateQualificationErrorsAtIssuanceTime(String certificateId) {
        return this.collectCertificateQualificationAtIssuanceTime(MessageType.ERROR, certificateId);
    }

    List<Message> getCertificateQualificationWarningsAtIssuanceTime(String certificateId) {
        return this.collectCertificateQualificationAtIssuanceTime(MessageType.WARN, certificateId);
    }

    List<Message> getCertificateQualificationInfosAtIssuanceTime(String certificateId) {
        return this.collectCertificateQualificationAtIssuanceTime(MessageType.INFO, certificateId);
    }

    List<Message> getCertificateQualificationErrorsAtValidationTime(String certificateId) {
        return this.collectCertificateQualificationAtValidationTime(MessageType.ERROR, certificateId);
    }

    List<Message> getCertificateQualificationWarningsAtValidationTime(String certificateId) {
        return this.collectCertificateQualificationAtValidationTime(MessageType.WARN, certificateId);
    }

    List<Message> getCertificateQualificationInfosAtValidationTime(String certificateId) {
        return this.collectCertificateQualificationAtValidationTime(MessageType.INFO, certificateId);
    }

    private List<Message> collectAdESValidationMessages(MessageType type, String tokenId) {
        XmlConclusion certXCVConclusion;
        XmlSignature signatureById = this.detailedReport.getXmlSignatureById(tokenId);
        if (signatureById != null) {
            return this.collectSignatureValidation(type, signatureById);
        }
        XmlTimestamp timestampById = this.detailedReport.getXmlTimestampById(tokenId);
        if (timestampById != null) {
            return this.collectTimestampValidation(type, timestampById);
        }
        XmlEvidenceRecord evidenceRecordById = this.detailedReport.getXmlEvidenceRecordById(tokenId);
        if (evidenceRecordById != null) {
            return this.collectEvidenceRecordValidation(type, evidenceRecordById);
        }
        XmlTLAnalysis tlAnalysisById = this.detailedReport.getTLAnalysisById(tokenId);
        if (tlAnalysisById != null) {
            return this.collectTLAnalysisValidation(type, tlAnalysisById);
        }
        XmlBasicBuildingBlocks bbbById = this.detailedReport.getBasicBuildingBlockById(tokenId);
        if (bbbById != null) {
            return this.collectBBBValidation(type, bbbById);
        }
        if (this.detailedReport.isCertificateValidation() && (certXCVConclusion = this.detailedReport.getCertificateXCVConclusion(tokenId)) != null) {
            return this.collectXmlConclusionValidation(type, certXCVConclusion);
        }
        return Collections.emptyList();
    }

    private List<Message> collectQualificationMessages(MessageType type, String tokenId) {
        XmlSignature signatureById = this.detailedReport.getXmlSignatureById(tokenId);
        if (signatureById != null) {
            return this.collectSignatureQualification(type, signatureById);
        }
        XmlTimestamp timestampById = this.detailedReport.getXmlTimestampById(tokenId);
        if (timestampById != null) {
            return this.collectTimestampQualification(type, timestampById);
        }
        XmlCertificate certificateById = this.detailedReport.getXmlCertificateById(tokenId);
        if (certificateById != null) {
            return this.collectCertificateQualification(type, certificateById);
        }
        return Collections.emptyList();
    }

    private List<Message> collectSignatureValidation(MessageType type, XmlSignature xmlSignature) {
        ArrayList<Message> result = new ArrayList<Message>();
        XmlConstraintsConclusion highestConclusion = this.detailedReport.getHighestConclusion(xmlSignature.getId());
        if (MessageType.ERROR != type || xmlSignature.getValidationProcessBasicSignature() != null && highestConclusion.getConclusion().getSubIndication() == xmlSignature.getValidationProcessBasicSignature().getConclusion().getSubIndication()) {
            this.addMessages(result, this.getMessages(type, xmlSignature.getValidationProcessBasicSignature()));
        }
        if (MessageType.ERROR != type || xmlSignature.getValidationProcessLongTermData() != null && highestConclusion.getConclusion().getSubIndication() == xmlSignature.getValidationProcessLongTermData().getConclusion().getSubIndication()) {
            this.addMessages(result, this.getMessages(type, xmlSignature.getValidationProcessLongTermData()));
        }
        this.addMessages(result, this.getMessages(type, highestConclusion));
        return result;
    }

    private List<Message> collectTimestampValidation(MessageType type, XmlTimestamp xmlTimestamp) {
        ArrayList<Message> result = new ArrayList<Message>();
        XmlValidationProcessBasicTimestamp timestampBasic = xmlTimestamp.getValidationProcessBasicTimestamp();
        XmlValidationProcessArchivalDataTimestamp timestampArchivalData = xmlTimestamp.getValidationProcessArchivalDataTimestamp();
        if (timestampArchivalData == null || MessageType.ERROR != type || !Indication.PASSED.equals(timestampArchivalData.getConclusion().getIndication())) {
            this.addMessages(result, this.getMessages(type, timestampBasic));
        }
        this.addMessages(result, this.getMessages(type, timestampArchivalData));
        return result;
    }

    private List<Message> collectEvidenceRecordValidation(MessageType type, XmlEvidenceRecord xmlEvidenceRecord) {
        ArrayList<Message> result = new ArrayList<Message>();
        XmlValidationProcessEvidenceRecord validationProcessEvidenceRecord = xmlEvidenceRecord.getValidationProcessEvidenceRecord();
        this.addMessages(result, this.getMessages(type, validationProcessEvidenceRecord));
        return result;
    }

    private List<Message> collectTLAnalysisValidation(MessageType type, XmlTLAnalysis tlAnalysisById) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, tlAnalysisById.getConclusion()));
        return result;
    }

    private List<Message> collectBBBValidation(MessageType type, XmlBasicBuildingBlocks bbbById) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, bbbById.getConclusion()));
        return result;
    }

    private List<Message> collectXmlConclusionValidation(MessageType type, XmlConclusion xmlConclusion) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, xmlConclusion));
        return result;
    }

    private List<Message> collectSignatureQualification(MessageType type, XmlSignature xmlSignature) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, xmlSignature.getValidationSignatureQualification()));
        return result;
    }

    private List<Message> collectTimestampQualification(MessageType type, XmlTimestamp xmlTimestamp) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, xmlTimestamp.getValidationTimestampQualification()));
        return result;
    }

    private List<Message> collectCertificateQualification(MessageType type, XmlCertificate xmlCertificate) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.collectCertificateQualificationAtIssuanceTime(type, xmlCertificate));
        this.addMessages(result, this.collectCertificateQualificationAtBestSignatureTime(type, xmlCertificate));
        this.addMessages(result, this.collectCertificateQualificationAtValidationTime(type, xmlCertificate));
        return result;
    }

    private List<Message> collectCertificateQualificationAtIssuanceTime(MessageType type, XmlCertificate xmlCertificate) {
        return this.collectCertificateQualificationAtTime(type, xmlCertificate, ValidationTime.CERTIFICATE_ISSUANCE_TIME);
    }

    private List<Message> collectCertificateQualificationAtBestSignatureTime(MessageType type, XmlCertificate xmlCertificate) {
        return this.collectCertificateQualificationAtTime(type, xmlCertificate, ValidationTime.BEST_SIGNATURE_TIME);
    }

    private List<Message> collectCertificateQualificationAtValidationTime(MessageType type, XmlCertificate xmlCertificate) {
        return this.collectCertificateQualificationAtTime(type, xmlCertificate, ValidationTime.VALIDATION_TIME);
    }

    private List<Message> collectCertificateQualificationAtIssuanceTime(MessageType type, String certificateId) {
        XmlCertificate xmlCertificate = this.detailedReport.getXmlCertificateById(certificateId);
        if (xmlCertificate != null) {
            return this.collectCertificateQualificationAtIssuanceTime(type, xmlCertificate);
        }
        return Collections.emptyList();
    }

    private List<Message> collectCertificateQualificationAtValidationTime(MessageType type, String certificateId) {
        XmlCertificate xmlCertificate = this.detailedReport.getXmlCertificateById(certificateId);
        if (xmlCertificate != null) {
            return this.collectCertificateQualificationAtValidationTime(type, xmlCertificate);
        }
        return Collections.emptyList();
    }

    private List<Message> collectCertificateQualificationAtTime(MessageType type, XmlCertificate xmlCertificate, ValidationTime validationTime) {
        for (XmlValidationCertificateQualification certificateQualification : xmlCertificate.getValidationCertificateQualification()) {
            if (!validationTime.equals((Object)certificateQualification.getValidationTime())) continue;
            return this.getMessages(type, certificateQualification);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The validation at time '{}' is not found or not performed!", (Object)validationTime);
        }
        return Collections.emptyList();
    }

    private List<Message> getMessages(MessageType type, XmlConstraintsConclusion constraintsConclusion) {
        if (constraintsConclusion != null) {
            return this.getMessages(type, constraintsConclusion.getConclusion());
        }
        return Collections.emptyList();
    }

    private List<Message> getMessages(MessageType type, XmlConclusion conclusion) {
        if (conclusion != null) {
            switch (type) {
                case ERROR: {
                    return this.convert(conclusion.getErrors());
                }
                case WARN: {
                    return this.convert(conclusion.getWarnings());
                }
                case INFO: {
                    return this.convert(conclusion.getInfos());
                }
            }
        }
        return Collections.emptyList();
    }

    private Message convert(XmlMessage m) {
        if (m != null) {
            return new Message(m.getKey(), m.getValue());
        }
        return null;
    }

    private List<Message> convert(Collection<XmlMessage> messages) {
        if (messages != null) {
            return messages.stream().map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void addMessage(List<Message> result, Message toAdd) {
        if (toAdd != null && !result.contains(toAdd)) {
            result.add(toAdd);
        }
    }

    private void addMessages(List<Message> result, Collection<Message> toAdd) {
        if (toAdd != null) {
            for (Message m : toAdd) {
                this.addMessage(result, m);
            }
        }
    }
}

