/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.common.digest.EvidenceRecordRenewalDigestBuilder;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import java.util.List;
import java.util.Objects;

public abstract class AbstractEvidenceRecordRenewalDigestBuilder
implements EvidenceRecordRenewalDigestBuilder {
    protected final DefaultEvidenceRecord evidenceRecord;
    protected final DigestAlgorithm digestAlgorithm;
    protected List<DSSDocument> detachedContent;

    protected AbstractEvidenceRecordRenewalDigestBuilder(DefaultEvidenceRecord evidenceRecord) {
        Objects.requireNonNull(evidenceRecord, "EvidenceRecord cannot be null!");
        this.evidenceRecord = evidenceRecord;
        this.digestAlgorithm = null;
    }

    protected AbstractEvidenceRecordRenewalDigestBuilder(DefaultEvidenceRecord evidenceRecord, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(evidenceRecord, "EvidenceRecord cannot be null!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.evidenceRecord = evidenceRecord;
        this.digestAlgorithm = digestAlgorithm;
    }

    public AbstractEvidenceRecordRenewalDigestBuilder setDetachedContent(List<DSSDocument> detachedContent) {
        this.detachedContent = detachedContent;
        return this;
    }

    protected ArchiveTimeStampObject getLastArchiveTimeStampObject() {
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = this.evidenceRecord.getArchiveTimeStampSequence();
        ArchiveTimeStampChainObject lastArchiveTimeStampChain = archiveTimeStampSequence.get(archiveTimeStampSequence.size() - 1);
        List<? extends ArchiveTimeStampObject> archiveTimeStamps = lastArchiveTimeStampChain.getArchiveTimeStamps();
        return archiveTimeStamps.get(archiveTimeStamps.size() - 1);
    }

    protected ArchiveTimeStampChainObject getLastArchiveTimeStampChainObject() {
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = this.evidenceRecord.getArchiveTimeStampSequence();
        return archiveTimeStampSequence.get(archiveTimeStampSequence.size() - 1);
    }

    protected DigestAlgorithm getDigestAlgorithm(ArchiveTimeStampChainObject archiveTimeStampChain) {
        return archiveTimeStampChain.getDigestAlgorithm();
    }

    @Override
    public abstract DSSMessageDigest buildTimeStampRenewalDigest();

    protected DigestAlgorithm getDigestAlgorithmOrDefault() {
        return this.digestAlgorithm != null ? this.digestAlgorithm : DigestAlgorithm.SHA256;
    }
}

