/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformation;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformationType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceRecordCertificateSource
extends TokenCertificateSource {
    private static final long serialVersionUID = -6983984636774915526L;
    private static final Logger LOG = LoggerFactory.getLogger(EvidenceRecordCertificateSource.class);
    private final List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence;

    public EvidenceRecordCertificateSource(List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence) {
        this.archiveTimeStampSequence = archiveTimeStampSequence;
        this.extractCertificates();
    }

    private void extractCertificates() {
        if (Utils.isCollectionEmpty(this.archiveTimeStampSequence)) {
            return;
        }
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : this.archiveTimeStampSequence) {
            List<? extends ArchiveTimeStampObject> archiveTimeStamps = archiveTimeStampChainObject.getArchiveTimeStamps();
            if (!Utils.isCollectionNotEmpty(archiveTimeStamps)) continue;
            for (ArchiveTimeStampObject archiveTimeStampObject : archiveTimeStamps) {
                List<CryptographicInformation> cryptographicInformationList = archiveTimeStampObject.getCryptographicInformationList();
                if (!Utils.isCollectionNotEmpty(cryptographicInformationList)) continue;
                for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
                    if (!CryptographicInformationType.CERT.equals((Object)cryptographicInformation.getType())) continue;
                    byte[] derEncodedCert = cryptographicInformation.getContent();
                    try {
                        CertificateToken cert = DSSUtils.loadCertificate(derEncodedCert);
                        this.addCertificate(cert, CertificateOrigin.EVIDENCE_RECORD);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to parse certificate '{}' : {}", Utils.toBase64(derEncodedCert), e.getMessage(), e);
                    }
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("+EvidenceRecordCertificateSource");
        }
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.EVIDENCE_RECORD;
    }
}

