/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation.timestamp;

import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;

public class EvidenceRecordTimestampIdentifierBuilder
extends TimestampIdentifierBuilder {
    private static final long serialVersionUID = -4742875671551626836L;
    private static final String ARCHIVE_TIMESTAMP_CHAIN_ORDER_PREFIX = "-ATC-";
    private static final String ARCHIVE_TIMESTAMP_ORDER_PREFIX = "-AT-";
    private static final String EVIDENCE_RECORD_ATTRIBUTE_ORDER_PREFIX = "-ER-";
    private static final String EVIDENCE_RECORD_WITHIN_ATTRIBUTE_ORDER_PREFIX = "-ERA-";
    private Integer archiveTimeStampChainOrder;
    private Integer archiveTimeStampOrder;
    private Integer evidenceRecordAttributeOrder;
    private Integer evidenceRecordWithinAttributeOrder;

    public EvidenceRecordTimestampIdentifierBuilder(byte[] timestampTokenBinaries) {
        super(timestampTokenBinaries);
    }

    public EvidenceRecordTimestampIdentifierBuilder setArchiveTimeStampChainOrder(Integer archiveTimeStampChainOrder) {
        this.archiveTimeStampChainOrder = archiveTimeStampChainOrder;
        return this;
    }

    public EvidenceRecordTimestampIdentifierBuilder setArchiveTimeStampOrder(Integer archiveTimeStampOrder) {
        this.archiveTimeStampOrder = archiveTimeStampOrder;
        return this;
    }

    public EvidenceRecordTimestampIdentifierBuilder setEvidenceRecordAttributeOrder(Integer evidenceRecordAttributeOrder) {
        this.evidenceRecordAttributeOrder = evidenceRecordAttributeOrder;
        return this;
    }

    public EvidenceRecordTimestampIdentifierBuilder setEvidenceRecordWithinAttributeOrder(Integer evidenceRecordWithinAttributeOrder) {
        this.evidenceRecordWithinAttributeOrder = evidenceRecordWithinAttributeOrder;
        return this;
    }

    @Override
    public EvidenceRecordTimestampIdentifierBuilder setFilename(String filename) {
        return (EvidenceRecordTimestampIdentifierBuilder)super.setFilename(filename);
    }

    @Override
    protected String getTimestampPosition() {
        StringBuilder sb = new StringBuilder();
        if (this.archiveTimeStampChainOrder != null) {
            sb.append(ARCHIVE_TIMESTAMP_CHAIN_ORDER_PREFIX);
            sb.append(this.archiveTimeStampChainOrder);
        }
        if (this.archiveTimeStampOrder != null) {
            sb.append(ARCHIVE_TIMESTAMP_ORDER_PREFIX);
            sb.append(this.archiveTimeStampOrder);
        }
        if (this.evidenceRecordAttributeOrder != null) {
            sb.append(EVIDENCE_RECORD_ATTRIBUTE_ORDER_PREFIX);
            sb.append(this.evidenceRecordAttributeOrder);
        }
        if (this.evidenceRecordWithinAttributeOrder != null) {
            sb.append(EVIDENCE_RECORD_WITHIN_ATTRIBUTE_ORDER_PREFIX);
            sb.append(this.evidenceRecordWithinAttributeOrder);
        }
        return sb.toString();
    }
}

