/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.digest;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.common.digest.AbstractEvidenceRecordRenewalDigestBuilderHelper;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSAttribute;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSElement;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSPath;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecord;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEvidenceRecordRenewalDigestBuilderHelper
extends AbstractEvidenceRecordRenewalDigestBuilderHelper {
    public XMLEvidenceRecordRenewalDigestBuilderHelper(XmlEvidenceRecord evidenceRecord) {
        super(evidenceRecord);
    }

    @Override
    public DSSMessageDigest buildTimeStampRenewalDigest(ArchiveTimeStampObject archiveTimeStamp) {
        XmlArchiveTimeStampChainObject archiveTimeStampChain = (XmlArchiveTimeStampChainObject)this.getArchiveTimeStampChainObject(archiveTimeStamp);
        return this.buildTimeStampRenewalDigest(archiveTimeStamp, archiveTimeStampChain.getDigestAlgorithm(), archiveTimeStampChain.getCanonicalizationMethod());
    }

    public DSSMessageDigest buildTimeStampRenewalDigest(ArchiveTimeStampObject archiveTimeStamp, DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        XmlArchiveTimeStampObject xmlArchiveTimeStampObject = (XmlArchiveTimeStampObject)archiveTimeStamp;
        Element archiveTimeStampElement = xmlArchiveTimeStampObject.getElement();
        Element timeStampElement = DomUtils.getElement(archiveTimeStampElement, XMLERSPath.TIME_STAMP_PATH);
        return this.getDigestOnCanonicalizedNode(timeStampElement, digestAlgorithm, canonicalizationMethod);
    }

    @Override
    public DSSMessageDigest buildArchiveTimeStampSequenceDigest(ArchiveTimeStampChainObject archiveTimeStampChain) {
        XmlArchiveTimeStampChainObject nextArchiveTimeStampChain = (XmlArchiveTimeStampChainObject)this.getNextArchiveTimeStampChain(archiveTimeStampChain);
        return this.buildArchiveTimeStampSequenceDigest(nextArchiveTimeStampChain.getDigestAlgorithm(), nextArchiveTimeStampChain.getCanonicalizationMethod(), nextArchiveTimeStampChain.getOrder());
    }

    public DSSMessageDigest buildArchiveTimeStampSequenceDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod, int archiveTimeStampChainOrder) {
        Element evidenceRecordElementCopy = this.createEvidenceRecordElementCopy();
        Element archiveTimeStampSequence = DomUtils.getElement(evidenceRecordElementCopy, XMLERSPath.ARCHIVE_TIME_STAMP_SEQUENCE_PATH);
        NodeList childNodes = archiveTimeStampSequence.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element archiceTimeStampChainElement;
            String order;
            Node node = childNodes.item(i);
            if (1 != node.getNodeType() || !XMLERSElement.ARCHIVE_TIME_STAMP_CHAIN.isSameTagName(node.getLocalName()) || !Utils.isStringNotEmpty(order = (archiceTimeStampChainElement = (Element)node).getAttribute(XMLERSAttribute.ORDER.getAttributeName())) || !Utils.isStringDigits(order)) continue;
            int intOrder = Integer.parseInt(order);
            if (archiveTimeStampChainOrder == -1 || intOrder < archiveTimeStampChainOrder) continue;
            archiveTimeStampSequence.removeChild(node);
            --i;
        }
        return this.getDigestOnCanonicalizedNode(archiveTimeStampSequence, digestAlgorithm, canonicalizationMethod);
    }

    private DSSMessageDigest getDigestOnCanonicalizedNode(Node node, DigestAlgorithm digestAlgorithm, String canonicalizationAlgorithm) {
        if (node != null) {
            DSSMessageDigest dSSMessageDigest;
            block9: {
                DSSMessageDigestCalculator messageDigestCalculator = new DSSMessageDigestCalculator(digestAlgorithm);
                OutputStream os = messageDigestCalculator.getOutputStream();
                try {
                    XMLCanonicalizer.createInstance(canonicalizationAlgorithm).canonicalize(node, os);
                    dSSMessageDigest = messageDigestCalculator.getMessageDigest(digestAlgorithm);
                    if (os == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DSSException("Unable to compute canonicalize a node", e);
                    }
                }
                os.close();
            }
            return dSSMessageDigest;
        }
        return null;
    }

    private Element createEvidenceRecordElementCopy() {
        XmlEvidenceRecord xmlEvidenceRecord = (XmlEvidenceRecord)this.evidenceRecord;
        Element evidenceRecordElement = xmlEvidenceRecord.getEvidenceRecordElement();
        return DomUtils.createDeepCopy(evidenceRecordElement);
    }
}

