/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.DigestValueGroup;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.xml.digest.XMLEvidenceRecordDataObjectDigestBuilder;
import eu.europa.esig.dss.evidencerecord.xml.digest.XMLEvidenceRecordRenewalDigestBuilderHelper;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlEvidenceRecord;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class XmlEvidenceRecordTimeStampSequenceVerifier
extends EvidenceRecordTimeStampSequenceVerifier {
    public XmlEvidenceRecordTimeStampSequenceVerifier(XmlEvidenceRecord evidenceRecord) {
        super(evidenceRecord);
    }

    @Override
    protected DataObjectDigestBuilder getDataObjectDigestBuilder(DSSDocument document, ArchiveTimeStampChainObject archiveTimeStampChain) {
        DigestAlgorithm digestAlgorithm = archiveTimeStampChain.getDigestAlgorithm();
        String canonicalizationMethod = this.getCanonicalizationMethod(archiveTimeStampChain);
        return new XMLEvidenceRecordDataObjectDigestBuilder(document, digestAlgorithm).setCanonicalizationMethod(canonicalizationMethod);
    }

    protected String getCanonicalizationMethod(ArchiveTimeStampChainObject archiveTimeStampChain) {
        XmlArchiveTimeStampChainObject xmlArchiveTimeStampChainObject = (XmlArchiveTimeStampChainObject)archiveTimeStampChain;
        return xmlArchiveTimeStampChainObject.getCanonicalizationMethod();
    }

    @Override
    protected List<? extends DigestValueGroup> getHashTree(List<? extends DigestValueGroup> originalHashTree, List<DSSDocument> detachedContents, ManifestFile manifestFile, ArchiveTimeStampChainObject archiveTimeStampChain, ArchiveTimeStampObject archiveTimeStamp, DSSMessageDigest lastTimeStampHash, DSSMessageDigest lastTimeStampSequenceHash) {
        DigestValueGroup firstDigestValueGroup;
        List<? extends DigestValueGroup> hashTree = super.getHashTree(originalHashTree, detachedContents, manifestFile, archiveTimeStampChain, archiveTimeStamp, lastTimeStampHash, lastTimeStampSequenceHash);
        if (lastTimeStampSequenceHash != null && !lastTimeStampSequenceHash.isEmpty() && Utils.collectionSize((firstDigestValueGroup = hashTree.get(0)).getDigestValues()) == 1) {
            ArrayList<byte[]> newDigestValuesGroup = new ArrayList<byte[]>(firstDigestValueGroup.getDigestValues());
            newDigestValuesGroup.add(DSSUtils.EMPTY_BYTE_ARRAY);
            firstDigestValueGroup.setDigestValues(newDigestValuesGroup);
        }
        return hashTree;
    }

    @Override
    protected DSSMessageDigest computeTimeStampHash(ArchiveTimeStampObject archiveTimeStamp) {
        return this.getEvidenceRecordRenewalDigestBuilderHelper().buildTimeStampRenewalDigest(archiveTimeStamp);
    }

    @Override
    protected DSSMessageDigest computeTimeStampSequenceHash(ArchiveTimeStampChainObject archiveTimeStampChain) {
        return this.getEvidenceRecordRenewalDigestBuilderHelper().buildArchiveTimeStampSequenceDigest(archiveTimeStampChain);
    }

    protected XMLEvidenceRecordRenewalDigestBuilderHelper getEvidenceRecordRenewalDigestBuilderHelper() {
        return new XMLEvidenceRecordRenewalDigestBuilderHelper((XmlEvidenceRecord)this.evidenceRecord);
    }
}

