/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.jades.HTTPHeader;
import eu.europa.esig.dss.jades.HTTPHeaderDigest;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HttpHeadersPayloadBuilder {
    private final List<DSSDocument> detachedContents;
    private final boolean isTimestamp;

    public HttpHeadersPayloadBuilder(List<DSSDocument> detachedContents, boolean isTimestamp) {
        this.detachedContents = detachedContents;
        this.isTimestamp = isTimestamp;
    }

    public byte[] build() {
        byte[] byArray;
        this.assertHttpHeadersConfigurationIsValid();
        List<HTTPHeader> httpHeaderDocuments = this.toHTTPHeaders(this.detachedContents);
        ArrayList<HTTPHeader> concatenatedHttpFields = new ArrayList<HTTPHeader>();
        for (HTTPHeader httpHeader : httpHeaderDocuments) {
            String headerName = Utils.trim(httpHeader.getName());
            String headerValue = Utils.trim(httpHeader.getValue());
            HTTPHeader concatenatedHttpHeader = this.getHTTPHeaderWithName(concatenatedHttpFields, headerName);
            if ("Digest".equals(headerName) && this.isTimestamp) {
                if (concatenatedHttpHeader != null) {
                    throw new IllegalArgumentException(String.format("Only one HTTPHeader with the name '%s' is allowed!", "Digest"));
                }
                if (!(httpHeader instanceof HTTPHeaderDigest)) {
                    throw new IllegalArgumentException("Unable to compute message-imprint for an Archive Timestamp! 'Digest' header must be an instance of HTTPHeaderDigest class.");
                }
                concatenatedHttpFields.add(httpHeader);
                continue;
            }
            if (concatenatedHttpHeader != null) {
                StringBuilder stringBuilder = new StringBuilder(concatenatedHttpHeader.getValue());
                stringBuilder.append(", ");
                stringBuilder.append(headerValue);
                headerValue = stringBuilder.toString();
                concatenatedHttpHeader.setValue(headerValue);
                continue;
            }
            concatenatedHttpHeader = new HTTPHeader(headerName, headerValue);
            concatenatedHttpFields.add(concatenatedHttpHeader);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Iterator iterator2 = concatenatedHttpFields.iterator();
            while (iterator2.hasNext()) {
                HTTPHeader header = (HTTPHeader)iterator2.next();
                if ("Digest".equals(header.getName()) && this.isTimestamp) {
                    HTTPHeaderDigest httpHeaderDigest = (HTTPHeaderDigest)header;
                    DSSDocument messageBodyDocument = httpHeaderDigest.getMessageBodyDocument();
                    baos.write(DSSUtils.toByteArray(messageBodyDocument));
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(Utils.lowerCase(header.getName()));
                    stringBuilder.append(":");
                    stringBuilder.append(" ");
                    stringBuilder.append(header.getValue());
                    baos.write(stringBuilder.toString().getBytes());
                }
                if (!iterator2.hasNext()) continue;
                baos.write("\n".getBytes());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building an HTTPHeaders payload : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return byArray;
    }

    private HTTPHeader getHTTPHeaderWithName(List<HTTPHeader> httpHeaders, String name) {
        for (HTTPHeader httpHeader : httpHeaders) {
            if (!name.equals(httpHeader.getName())) continue;
            return httpHeader;
        }
        return null;
    }

    private List<HTTPHeader> toHTTPHeaders(List<DSSDocument> dssDocuments) {
        ArrayList<HTTPHeader> httpHeaderDocuments = new ArrayList<HTTPHeader>();
        for (DSSDocument document : dssDocuments) {
            if (document instanceof HTTPHeader) {
                HTTPHeader httpHeaderDocument = (HTTPHeader)document;
                httpHeaderDocuments.add(httpHeaderDocument);
                continue;
            }
            throw new IllegalArgumentException(String.format("The document with name '%s' is not of type HTTPHeader!", document.getName()));
        }
        return httpHeaderDocuments;
    }

    private void assertHttpHeadersConfigurationIsValid() {
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            boolean digestDocumentFound = false;
            for (DSSDocument document : this.detachedContents) {
                boolean digestHTTPHeaderDocument = this.checkIfDigestHTTPHeaderDocument(document);
                if (!digestHTTPHeaderDocument) continue;
                if (digestDocumentFound) {
                    throw new IllegalArgumentException("Only one 'Digest' header or HTTPHeaderDigest object is allowed!");
                }
                digestDocumentFound = true;
            }
        } else {
            throw new IllegalArgumentException("Unable to compute HTTPHeaders payload! The list of detached documents is empty.");
        }
    }

    private boolean checkIfDigestHTTPHeaderDocument(DSSDocument document) {
        if (!(document instanceof HTTPHeader)) {
            throw new IllegalArgumentException("The documents to sign must have a type of HTTPHeader for 'sigD' HttpHeaders mechanism!");
        }
        if ("Digest".equals(document.getName())) {
            if (!(document instanceof HTTPHeaderDigest) && this.isTimestamp) {
                throw new IllegalArgumentException("Unable to compute message-imprint for a Timestamp! 'Digest' header must be an instance of HTTPHeaderDigest class.");
            }
            return true;
        }
        return false;
    }
}

