/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESAttributeIdentifier;
import java.util.Map;

public class EtsiUComponent
extends JAdESAttribute {
    private static final long serialVersionUID = -4134366074771198071L;
    private final boolean base64UrlEncoded;
    private final Object component;

    EtsiUComponent(Object component, String headerName, Object value, JAdESAttributeIdentifier identifier) {
        super(headerName, value);
        this.component = component;
        this.base64UrlEncoded = DSSJsonUtils.isStringFormat(component);
        this.identifier = identifier;
    }

    public static EtsiUComponent build(Object component, int order) {
        Map<String, Object> map = DSSJsonUtils.parseEtsiUComponent(component);
        if (map != null) {
            Map.Entry<String, Object> mapEntry = map.entrySet().iterator().next();
            String headerName = mapEntry.getKey();
            Object value = mapEntry.getValue();
            JAdESAttributeIdentifier identifier = JAdESAttributeIdentifier.build(headerName, value, order);
            return new EtsiUComponent(component, headerName, value, identifier);
        }
        return null;
    }

    public static EtsiUComponent build(String headerName, Object value, boolean base64UrlEncoded, JAdESAttributeIdentifier identifier) {
        Object component = EtsiUComponent.createEtsiUComponent(headerName, value, base64UrlEncoded);
        return new EtsiUComponent(component, headerName, value, identifier);
    }

    private static Object createEtsiUComponent(String name, Object value, boolean base64UrlEncoded) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put(name, value);
        return base64UrlEncoded ? DSSJsonUtils.toBase64Url(jsonObject) : jsonObject;
    }

    public Object getComponent() {
        return this.component;
    }

    public boolean isBase64UrlEncoded() {
        return this.base64UrlEncoded;
    }
}

