/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.JWSCompactDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.JWSSerializationAnalyzerValidator;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzerFactory;

public class JWSDocumentAnalyzerFactory
implements DocumentAnalyzerFactory {
    @Override
    public boolean isSupported(DSSDocument document) {
        JWSCompactDocumentAnalyzer compactValidator = new JWSCompactDocumentAnalyzer();
        if (compactValidator.isSupported(document)) {
            return true;
        }
        JWSSerializationAnalyzerValidator serializationValidator = new JWSSerializationAnalyzerValidator();
        return serializationValidator.isSupported(document);
    }

    @Override
    public AbstractJWSDocumentAnalyzer create(DSSDocument document) {
        JWSCompactDocumentAnalyzer compactValidator = new JWSCompactDocumentAnalyzer();
        if (compactValidator.isSupported(document)) {
            return new JWSCompactDocumentAnalyzer(document);
        }
        JWSSerializationAnalyzerValidator serializationValidator = new JWSSerializationAnalyzerValidator();
        if (serializationValidator.isSupported(document)) {
            return new JWSSerializationAnalyzerValidator(document);
        }
        throw new IllegalArgumentException("Not supported document");
    }
}

