/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509;

import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.CertificateTokenIdentifier;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.identifier.EntityIdentifierBuilder;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificateToken
extends Token {
    private final X509Certificate x509Certificate;
    private final EntityIdentifier entityKey;
    private Boolean selfSigned;
    private List<KeyUsageBit> keyUsageBits;
    private String sourceURL;

    public CertificateToken(X509Certificate x509Certificate) {
        Objects.requireNonNull(x509Certificate, "X509 certificate is missing");
        this.x509Certificate = x509Certificate;
        this.entityKey = new EntityIdentifierBuilder(x509Certificate.getPublicKey(), x509Certificate.getSubjectX500Principal()).build();
        this.signatureAlgorithm = SignatureAlgorithm.forOidAndParams(x509Certificate.getSigAlgOID(), x509Certificate.getSigAlgParams());
    }

    @Override
    public String getAbbreviation() {
        return this.getDSSIdAsString();
    }

    public EntityIdentifier getEntityKey() {
        return this.entityKey;
    }

    @Override
    public EntityIdentifier getIssuerEntityKey() {
        if (this.isSelfSigned()) {
            return new EntityIdentifierBuilder(this.getPublicKey(), this.getSubject().getPrincipal()).build();
        }
        return super.getIssuerEntityKey();
    }

    public PublicKey getPublicKey() {
        return this.x509Certificate.getPublicKey();
    }

    public Date getNotAfter() {
        return this.x509Certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.x509Certificate.getNotBefore();
    }

    @Override
    public Date getCreationDate() {
        return this.getNotBefore();
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public boolean isValidOn(Date date) {
        if (this.x509Certificate == null || date == null) {
            return false;
        }
        try {
            this.x509Certificate.checkValidity(date);
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return false;
        }
    }

    @Override
    public boolean isSelfSigned() {
        if (this.selfSigned == null) {
            this.selfSigned = this.isSelfIssued();
            if (this.selfSigned.booleanValue()) {
                try {
                    this.x509Certificate.verify(this.x509Certificate.getPublicKey());
                    this.selfSigned = true;
                    this.signatureValidity = SignatureValidity.VALID;
                }
                catch (Exception e) {
                    this.selfSigned = false;
                }
            }
        } else if (this.selfSigned.booleanValue()) {
            this.signatureValidity = SignatureValidity.VALID;
        }
        return this.selfSigned;
    }

    public boolean isSelfIssued() {
        return Arrays.equals(this.x509Certificate.getSubjectX500Principal().getEncoded(), this.x509Certificate.getIssuerX500Principal().getEncoded());
    }

    public boolean isEquivalent(CertificateToken token) {
        PublicKey currentPublicKey = this.getPublicKey();
        PublicKey tokenPublicKey = token.getPublicKey();
        return Arrays.equals(currentPublicKey.getEncoded(), tokenPublicKey.getEncoded());
    }

    public X509Certificate getCertificate() {
        return this.x509Certificate;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new DSSException("Unable to encode the certificate", e);
        }
    }

    public BigInteger getSerialNumber() {
        return this.x509Certificate.getSerialNumber();
    }

    public X500PrincipalHelper getSubject() {
        return new X500PrincipalHelper(this.x509Certificate.getSubjectX500Principal());
    }

    public X500PrincipalHelper getIssuer() {
        return new X500PrincipalHelper(this.x509Certificate.getIssuerX500Principal());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.x509Certificate.getIssuerX500Principal();
    }

    @Override
    protected SignatureValidity checkIsSignedBy(PublicKey publicKey) {
        this.signatureValidity = SignatureValidity.INVALID;
        this.signatureInvalidityReason = "";
        try {
            this.x509Certificate.verify(publicKey);
            this.signatureValidity = SignatureValidity.VALID;
        }
        catch (NoSuchProviderException e) {
            throw new DSSException(String.format("No provider has been found for signature validation : %s", e.getMessage()), e);
        }
        catch (Exception e) {
            this.signatureInvalidityReason = e.getClass().getSimpleName() + " : " + e.getMessage();
        }
        return this.signatureValidity;
    }

    public boolean checkKeyUsage(KeyUsageBit keyUsageBit) {
        return this.getKeyUsageBits().contains((Object)keyUsageBit);
    }

    public List<KeyUsageBit> getKeyUsageBits() {
        if (this.keyUsageBits == null) {
            this.keyUsageBits = new ArrayList<KeyUsageBit>();
            boolean[] keyUsageArray = this.x509Certificate.getKeyUsage();
            if (keyUsageArray != null) {
                for (KeyUsageBit keyUsageBit : KeyUsageBit.values()) {
                    if (!keyUsageArray[keyUsageBit.getIndex()]) continue;
                    this.keyUsageBits.add(keyUsageBit);
                }
            }
        }
        return this.keyUsageBits;
    }

    public boolean isCA() {
        return this.x509Certificate.getBasicConstraints() != -1;
    }

    public int getPathLenConstraint() {
        return this.x509Certificate.getBasicConstraints();
    }

    public byte[] getSignature() {
        return this.x509Certificate.getSignature();
    }

    @Override
    protected TokenIdentifier buildTokenIdentifier() {
        return new CertificateTokenIdentifier(this);
    }

    @Override
    public String toString(String indentStr) {
        StringBuilder out = new StringBuilder();
        out.append(indentStr).append("CertificateToken[\n");
        indentStr = indentStr + "\t";
        out.append(indentStr).append("DSS Id              : ").append(this.getDSSIdAsString()).append('\n');
        out.append(indentStr).append("Identity Id         : ").append(this.getEntityKey()).append('\n');
        out.append(indentStr).append("Validity period     : ").append(this.x509Certificate.getNotBefore()).append(" - ").append(this.x509Certificate.getNotAfter()).append('\n');
        out.append(indentStr).append("Subject name        : ").append(this.getSubject().getCanonical()).append('\n');
        out.append(indentStr).append("Issuer subject name : ").append(this.getIssuer().getCanonical()).append('\n');
        out.append(indentStr).append("Serial Number       : ").append(this.getSerialNumber()).append('\n');
        out.append(indentStr).append("Signature algorithm : ").append(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm).append('\n');
        if (this.isSelfSigned()) {
            out.append(indentStr).append("[SELF-SIGNED]").append('\n');
        }
        indentStr = indentStr.substring(1);
        out.append(indentStr).append(']');
        return out.toString();
    }
}

