/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CMSBuilder;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.signature.PAdESSignerInfoGeneratorBuilder;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SignatureValueChecker;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.Collections;
import java.util.Objects;
import org.bouncycastle.cms.SignerInfoGenerator;

public class ExternalCMSService {
    private final CertificateVerifier certificateVerifier;
    private TSPSource tspSource;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;

    public ExternalCMSService(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = CMSUtils.getDSSResourcesHandlerBuilder(resourcesHandlerBuilder);
    }

    public ToBeSigned getDataToSign(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(messageDigest, "messageDigest cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertConfigurationValid(messageDigest, parameters);
        return this.buildToBeSignedData(messageDigest, parameters);
    }

    protected ToBeSigned buildToBeSignedData(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        SignerInfoGenerator signerInfoGenerator = new PAdESSignerInfoGeneratorBuilder(messageDigest).build(parameters, customContentSigner);
        CMSBuilder cmsBuilder = this.getCMSSignedDataBuilder(parameters);
        cmsBuilder.createCMS(signerInfoGenerator, new InMemoryDocument(messageDigest.getValue()));
        byte[] dataToSign = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(dataToSign);
    }

    public DSSDocument signMessageDigest(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(messageDigest, "messageDigest cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertConfigurationValid(messageDigest, parameters);
        CMS cms = this.buildCMS(messageDigest, parameters, signatureValue);
        parameters.reinit();
        return CMSUtils.writeToDSSDocument(cms, this.resourcesHandlerBuilder);
    }

    protected CMS buildCMS(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        signatureValue = new SignatureValueChecker().ensureSignatureValue(signatureValue, parameters.getSignatureAlgorithm());
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        SignerInfoGenerator signerInfoGenerator = new PAdESSignerInfoGeneratorBuilder(messageDigest).build(parameters, customContentSigner);
        CMS cms = this.getCMSSignedDataBuilder(parameters).createCMS(signerInfoGenerator, new InMemoryDocument(messageDigest.getValue()));
        if (!SignatureLevel.PAdES_BASELINE_B.equals((Object)signatureLevel)) {
            Objects.requireNonNull(this.tspSource, "TSPSource shall be provided for T-level creation!");
            DigestDocument digestDocument = DSSUtils.toDigestDocument(messageDigest);
            parameters.getContext().setDetachedContents(Collections.singletonList(digestDocument));
            CAdESLevelBaselineT cadesLevelBaselineT = new CAdESLevelBaselineT(this.tspSource, this.certificateVerifier);
            cms = cadesLevelBaselineT.extendCMSSignatures(cms, parameters);
        }
        return cms;
    }

    protected void assertConfigurationValid(DSSMessageDigest messageDigest, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel shall be defined!");
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (!SignatureLevel.PAdES_BASELINE_B.equals((Object)signatureLevel) && !SignatureLevel.PAdES_BASELINE_T.equals((Object)signatureLevel)) {
            throw new IllegalArgumentException(String.format("SignatureLevel '%s' is not supported within PAdESCMSGeneratorService!", new Object[]{signatureLevel}));
        }
        this.assertSigningCertificateValid(parameters);
        if (messageDigest.getAlgorithm() != parameters.getDigestAlgorithm()) {
            throw new IllegalArgumentException(String.format("The DigestAlgorithm provided within Digest '%s' does not correspond to the one defined in SignatureParameters '%s'!", messageDigest.getAlgorithm(), parameters.getDigestAlgorithm()));
        }
    }

    protected void assertSigningCertificateValid(AbstractSignatureParameters<?> parameters) {
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        if (signingCertificate == null) {
            if (parameters.isGenerateTBSWithoutCertificate()) {
                return;
            }
            throw new IllegalArgumentException("Signing Certificate is not defined! Set signing certificate or use method setGenerateTBSWithoutCertificate(true).");
        }
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, parameters);
        signatureRequirementsChecker.assertSigningCertificateIsValid(signingCertificate);
    }

    private CMSBuilder getCMSSignedDataBuilder(PAdESSignatureParameters parameters) {
        return new CMSBuilder().setSigningCertificate(parameters.getSigningCertificate()).setCertificateChain(parameters.getCertificateChain()).setGenerateWithoutCertificates(parameters.isGenerateTBSWithoutCertificate()).setTrustAnchorBPPolicy(parameters.bLevel().isTrustAnchorBPPolicy()).setTrustedCertificateSource(this.certificateVerifier.getTrustedCertSources()).setEncapsulate(false);
    }
}

