/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.signature.PAdESSignatureRequirementsChecker;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentAnalyzer;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.executor.CompleteValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Objects;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private final TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;
    protected final IPdfObjFactory pdfObjectFactory;

    protected PAdESLevelBaselineT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        Objects.requireNonNull(tspSource, "TSPSource shall be defined!");
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier shall be defined!");
        Objects.requireNonNull(pdfObjectFactory, "pdfObjectFactory shall be defined!");
        this.tspSource = tspSource;
        this.certificateVerifier = certificateVerifier;
        this.pdfObjectFactory = pdfObjectFactory;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) {
        Objects.requireNonNull(document, "DSSDocument cannot be null!");
        Objects.requireNonNull(params, "SignatureParameters cannot be null!");
        PDFDocumentAnalyzer pdfDocumentValidator = this.getPDFDocumentValidator(document, params);
        return this.extendSignatures(document, pdfDocumentValidator, params);
    }

    protected DSSDocument extendSignatures(DSSDocument document, PDFDocumentAnalyzer pdfDocumentAnalyzer, PAdESSignatureParameters parameters) {
        List<AdvancedSignature> signatures = pdfDocumentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        if (this.isTLevelExtensionRequired(parameters, signatures)) {
            PAdESSignatureRequirementsChecker signatureRequirementsChecker = new PAdESSignatureRequirementsChecker(this.certificateVerifier, parameters);
            signatureRequirementsChecker.assertExtendToTLevelPossible(signatures);
            signatureRequirementsChecker.assertSignaturesValid(signatures);
            signatureRequirementsChecker.assertSigningCertificateIsValid(signatures);
            return this.timestampDocument(document, parameters.getSignatureTimestampParameters(), parameters.getPasswordProtection(), this.getSignatureTimestampService());
        }
        return document;
    }

    private PDFSignatureService getSignatureTimestampService() {
        return this.pdfObjectFactory.newSignatureTimestampService();
    }

    protected DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters timestampParameters, char[] pwd, PDFSignatureService pdfSignatureService) {
        PAdESTimestampService padesTimestampService = new PAdESTimestampService(this.tspSource, pdfSignatureService);
        timestampParameters.setPasswordProtection(pwd);
        return padesTimestampService.timestampDocument(document, timestampParameters);
    }

    protected PDFDocumentAnalyzer getPDFDocumentValidator(DSSDocument document, PAdESSignatureParameters parameters) {
        PDFDocumentAnalyzer pdfDocumentValidator = new PDFDocumentAnalyzer(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentValidator.setValidationContextExecutor(CompleteValidationContextExecutor.INSTANCE);
        pdfDocumentValidator.setPasswordProtection(parameters.getPasswordProtection());
        pdfDocumentValidator.setPdfObjFactory(this.pdfObjectFactory);
        return pdfDocumentValidator;
    }

    private boolean isTLevelExtensionRequired(PAdESSignatureParameters parameters, List<AdvancedSignature> signatures) {
        boolean tLevelExtensionRequired = false;
        for (AdvancedSignature signature : signatures) {
            PAdESSignature padesSignature = (PAdESSignature)signature;
            if (!this.requiresDocumentTimestamp(padesSignature, parameters)) continue;
            tLevelExtensionRequired = true;
        }
        return tLevelExtensionRequired;
    }

    private boolean requiresDocumentTimestamp(PAdESSignature signature, PAdESSignatureParameters signatureParameters) {
        return SignatureLevel.PAdES_BASELINE_T.equals((Object)signatureParameters.getSignatureLevel()) || !signature.hasTProfile();
    }
}

