/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCmsOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(PdfCmsOCSPSource.class);

    public PdfCmsOCSPSource(AttributeTable signedAttributes) {
        this.extractOCSPArchivalValues(signedAttributes);
    }

    private void extractOCSPArchivalValues(AttributeTable signedAttributes) {
        if (signedAttributes != null) {
            Attribute[] attributes;
            for (Attribute attribute : attributes = DSSASN1Utils.getAsn1Attributes(signedAttributes, OID.adbe_revocationInfoArchival)) {
                Object[] attributeValues = attribute.getAttributeValues();
                if (!Utils.isArrayNotEmpty(attributeValues)) continue;
                for (Object attrValue : attributeValues) {
                    this.extractRevocationInfoArchival((ASN1Encodable)attrValue);
                }
            }
        }
    }

    private void extractRevocationInfoArchival(ASN1Encodable attValue) {
        RevocationInfoArchival revocationArchival = PAdESUtils.getRevocationInfoArchival(attValue);
        if (revocationArchival != null) {
            for (OCSPResponse ocspResponse : revocationArchival.getOcspVals()) {
                try {
                    BasicOCSPResp basicOCSPResponse = DSSASN1Utils.toBasicOCSPResp(ocspResponse);
                    this.addBinary(OCSPResponseBinary.build(basicOCSPResponse), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (OCSPException e) {
                    LOG.warn("Error while extracting OCSPResponse from Revocation Info Archivals (ADBE) : {}", (Object)e.getMessage());
                }
            }
        }
    }
}

