/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCRLSource;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PdfValidationDataContainer
extends ValidationDataContainer {
    private final Collection<PdfDocDssRevision> pdfDssRevisions;
    private Map<String, PdfObjectKey> knownObjects;

    public PdfValidationDataContainer(Collection<PdfDocDssRevision> pdfDssRevisions) {
        this.pdfDssRevisions = pdfDssRevisions;
    }

    public Map<String, PdfObjectKey> getKnownObjectsMap() {
        if (this.knownObjects == null) {
            this.knownObjects = new HashMap<String, PdfObjectKey>();
            if (Utils.isCollectionNotEmpty(this.pdfDssRevisions)) {
                for (PdfDocDssRevision dssRevision : this.pdfDssRevisions) {
                    PdfDssDictCertificateSource certificateSource = dssRevision.getCertificateSource();
                    Map<PdfObjectKey, CertificateToken> storedCertificates = certificateSource.getCertificateMap();
                    for (Map.Entry<PdfObjectKey, CertificateToken> certEntry : storedCertificates.entrySet()) {
                        String tokenKey = this.getTokenKey(certEntry.getValue());
                        if (this.knownObjects.containsKey(tokenKey)) continue;
                        this.knownObjects.put(tokenKey, certEntry.getKey());
                    }
                    PdfDssDictCRLSource crlSource = dssRevision.getCRLSource();
                    Map<PdfObjectKey, CRLBinary> storedCrls = crlSource.getCrlMap();
                    for (Map.Entry entry : storedCrls.entrySet()) {
                        String tokenKey = ((CRLBinary)entry.getValue()).asXmlId();
                        if (this.knownObjects.containsKey(tokenKey)) continue;
                        this.knownObjects.put(tokenKey, (PdfObjectKey)entry.getKey());
                    }
                    PdfDssDictOCSPSource ocspSource = dssRevision.getOCSPSource();
                    Map<PdfObjectKey, OCSPResponseBinary> map = ocspSource.getOcspMap();
                    for (Map.Entry<PdfObjectKey, OCSPResponseBinary> ocspEntry : map.entrySet()) {
                        OCSPResponseBinary ocspResponseBinary = ocspEntry.getValue();
                        String tokenKey = ocspResponseBinary.getDSSId().asXmlId();
                        if (this.knownObjects.containsKey(tokenKey)) continue;
                        this.knownObjects.put(tokenKey, ocspEntry.getKey());
                    }
                }
            }
        }
        return this.knownObjects;
    }

    public PdfObjectKey getTokenReference(Token token) {
        String tokenKey = this.getTokenKey(token);
        return this.getKnownObjectsMap().get(tokenKey);
    }

    public String getTokenKey(Token token) {
        if (token instanceof CertificateToken) {
            return ((CertificateToken)token).getEntityKey().asXmlId();
        }
        return token.getDSSIdAsString();
    }
}

