/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.dss.PdfCompositeDssDictOCSPSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfDssDictOCSPSource
extends OfflineOCSPSource {
    private static final long serialVersionUID = 1503525374769179608L;
    private final PdfCompositeDssDictOCSPSource compositeOCSPSource;
    private final PdfDssDict dssDictionary;
    private final String relatedVRIDictionaryName;
    private Map<PdfObjectKey, OCSPResponseBinary> ocspMap;

    public PdfDssDictOCSPSource(PdfCompositeDssDictOCSPSource compositeOCSPSource, PdfDssDict dssDictionary) {
        this(compositeOCSPSource, dssDictionary, null);
    }

    public PdfDssDictOCSPSource(PdfCompositeDssDictOCSPSource compositeOCSPSource, PdfDssDict dssDictionary, String vriDictionaryName) {
        this.compositeOCSPSource = compositeOCSPSource;
        this.dssDictionary = dssDictionary;
        this.relatedVRIDictionaryName = vriDictionaryName;
    }

    public Map<PdfObjectKey, OCSPResponseBinary> getOcspMap() {
        if (this.ocspMap == null) {
            this.ocspMap = new HashMap<PdfObjectKey, OCSPResponseBinary>();
            if (this.dssDictionary != null) {
                this.ocspMap.putAll(this.dssDictionary.getOCSPs());
                List<PdfVriDict> vriDicts = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
                for (PdfVriDict vriDict : vriDicts) {
                    this.ocspMap.putAll(vriDict.getOCSPs());
                }
            }
        }
        return this.ocspMap;
    }

    @Override
    public List<RevocationToken<OCSP>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        List<RevocationToken<OCSP>> revocationTokens = this.compositeOCSPSource.getRevocationTokens(certificateToken, issuerToken);
        return this.filterTokensFromOcspMap(revocationTokens);
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier<OCSP>> getDSSDictionaryBinaries() {
        if (this.dssDictionary != null) {
            return this.filterBinariesFromKeys(this.compositeOCSPSource.getDSSDictionaryBinaries(), this.dssDictionary.getOCSPs().keySet());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RevocationToken<OCSP>> getDSSDictionaryTokens() {
        if (this.dssDictionary != null) {
            return this.filterTokensFromKeys(this.compositeOCSPSource.getDSSDictionaryTokens(), this.dssDictionary.getOCSPs().keySet());
        }
        return Collections.emptyList();
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier<OCSP>> getVRIDictionaryBinaries() {
        if (this.dssDictionary != null) {
            return this.filterBinariesFromKeys(this.compositeOCSPSource.getVRIDictionaryBinaries(), this.getKeySetFromVRIDictionaries());
        }
        return Collections.emptyList();
    }

    @Override
    public List<RevocationToken<OCSP>> getVRIDictionaryTokens() {
        if (this.dssDictionary != null) {
            return this.filterTokensFromKeys(this.compositeOCSPSource.getVRIDictionaryTokens(), this.getKeySetFromVRIDictionaries());
        }
        return Collections.emptyList();
    }

    private Set<PdfObjectKey> getKeySetFromVRIDictionaries() {
        if (this.dssDictionary != null) {
            HashSet<PdfObjectKey> result = new HashSet<PdfObjectKey>();
            List<PdfVriDict> vris = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
            for (PdfVriDict vriDict : vris) {
                result.addAll(vriDict.getOCSPs().keySet());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private List<EncapsulatedRevocationTokenIdentifier<OCSP>> filterBinariesFromKeys(Collection<EncapsulatedRevocationTokenIdentifier<OCSP>> ocspBinaries, Collection<PdfObjectKey> keySet) {
        ArrayList<EncapsulatedRevocationTokenIdentifier<OCSP>> result = new ArrayList<EncapsulatedRevocationTokenIdentifier<OCSP>>();
        for (EncapsulatedRevocationTokenIdentifier<OCSP> OCSPBinary : ocspBinaries) {
            Set<PdfObjectKey> objectIds = this.compositeOCSPSource.getTokenBinaryObjectIds(OCSPBinary);
            if (!Utils.containsAny(keySet, objectIds)) continue;
            result.add(OCSPBinary);
        }
        return result;
    }

    private List<RevocationToken<OCSP>> filterTokensFromOcspMap(List<RevocationToken<OCSP>> revocationTokens) {
        return this.filterTokensFromKeys(revocationTokens, this.getOcspMap().keySet());
    }

    private List<RevocationToken<OCSP>> filterTokensFromKeys(Collection<RevocationToken<OCSP>> revocationTokens, Collection<PdfObjectKey> keySet) {
        ArrayList<RevocationToken<OCSP>> result = new ArrayList<RevocationToken<OCSP>>();
        for (RevocationToken<OCSP> OCSPToken2 : revocationTokens) {
            Set<PdfObjectKey> objectIds = this.compositeOCSPSource.getRevocationTokenIds(OCSPToken2);
            if (!Utils.containsAny(keySet, objectIds)) continue;
            result.add(OCSPToken2);
        }
        return result;
    }

    @Override
    public Map<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>> getAllRevocationBinariesWithOrigins() {
        HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>> result = new HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<RevocationOrigin>>();
        Set<EncapsulatedRevocationTokenIdentifier<OCSP>> binaries = this.compositeOCSPSource.getAllRevocationBinaries();
        List<EncapsulatedRevocationTokenIdentifier<OCSP>> filteredBinaries = this.filterBinariesFromKeys(binaries, this.getOcspMap().keySet());
        for (EncapsulatedRevocationTokenIdentifier<OCSP> ocspBinary : filteredBinaries) {
            result.put(ocspBinary, this.getRevocationDataOrigins(ocspBinary));
        }
        return result;
    }

    private Set<RevocationOrigin> getRevocationDataOrigins(EncapsulatedRevocationTokenIdentifier<OCSP> ocspBinary) {
        HashSet<RevocationOrigin> result = new HashSet<RevocationOrigin>();
        Set<PdfObjectKey> tokenBinaryObjectIds = this.compositeOCSPSource.getTokenBinaryObjectIds(ocspBinary);
        if (Utils.containsAny(this.dssDictionary.getOCSPs().keySet(), tokenBinaryObjectIds)) {
            result.add(RevocationOrigin.DSS_DICTIONARY);
        }
        for (PdfVriDict vriDict : PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName)) {
            if (!Utils.containsAny(vriDict.getOCSPs().keySet(), tokenBinaryObjectIds)) continue;
            result.add(RevocationOrigin.VRI_DICTIONARY);
        }
        return result;
    }

    @Override
    public Map<RevocationToken<OCSP>, Set<RevocationOrigin>> getAllRevocationTokensWithOrigins() {
        HashMap<RevocationToken<OCSP>, Set<RevocationOrigin>> result = new HashMap<RevocationToken<OCSP>, Set<RevocationOrigin>>();
        Set<RevocationToken<OCSP>> tokens = this.compositeOCSPSource.getAllRevocationTokens();
        List<RevocationToken<OCSP>> filteredBinaries = this.filterTokensFromKeys(tokens, this.getOcspMap().keySet());
        for (RevocationToken<OCSP> ocspToken : filteredBinaries) {
            result.put(ocspToken, this.getRevocationDataOrigins(ocspToken));
        }
        return result;
    }

    private Set<RevocationOrigin> getRevocationDataOrigins(RevocationToken<OCSP> ocspToken) {
        HashSet<RevocationOrigin> result = new HashSet<RevocationOrigin>();
        Set<PdfObjectKey> tokenObjectIds = this.compositeOCSPSource.getRevocationTokenIds(ocspToken);
        if (Utils.containsAny(this.dssDictionary.getOCSPs().keySet(), tokenObjectIds)) {
            result.add(RevocationOrigin.DSS_DICTIONARY);
        }
        for (PdfVriDict vriDict : PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName)) {
            if (!Utils.containsAny(vriDict.getOCSPs().keySet(), tokenObjectIds)) continue;
            result.add(RevocationOrigin.VRI_DICTIONARY);
        }
        return result;
    }
}

