/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

public class PdfMemoryUsageSetting {
    private final Mode mode;
    private final long maxMemoryBytes;
    private final long maxStorageBytes;

    protected PdfMemoryUsageSetting(Mode mode) {
        this(mode, -1L, -1L);
    }

    protected PdfMemoryUsageSetting(Mode mode, long maxMemoryBytes, long maxStorageBytes) {
        this.mode = mode;
        this.maxMemoryBytes = maxMemoryBytes;
        this.maxStorageBytes = maxStorageBytes;
    }

    public Mode getMode() {
        return this.mode;
    }

    public long getMaxMemoryBytes() {
        return this.maxMemoryBytes;
    }

    public long getMaxStorageBytes() {
        return this.maxStorageBytes;
    }

    public static PdfMemoryUsageSetting memoryFull() {
        return new PdfMemoryUsageSetting(Mode.MEMORY_FULL);
    }

    public static PdfMemoryUsageSetting memoryBuffered() {
        return PdfMemoryUsageSetting.memoryBuffered(-1L);
    }

    public static PdfMemoryUsageSetting memoryBuffered(long maxBytes) {
        return new PdfMemoryUsageSetting(Mode.MEMORY_BUFFERED, maxBytes, -1L);
    }

    public static PdfMemoryUsageSetting fileOnly() {
        return PdfMemoryUsageSetting.fileOnly(-1L);
    }

    public static PdfMemoryUsageSetting fileOnly(long maxStorageBytes) {
        return new PdfMemoryUsageSetting(Mode.FILE, -1L, maxStorageBytes);
    }

    public static PdfMemoryUsageSetting mixed(long maxMemoryBytes) {
        return PdfMemoryUsageSetting.mixed(maxMemoryBytes, -1L);
    }

    public static PdfMemoryUsageSetting mixed(long maxMemoryBytes, long maxStorageBytes) {
        return new PdfMemoryUsageSetting(Mode.MIXED, maxMemoryBytes, maxStorageBytes);
    }

    public String toString() {
        return String.format("%s[%s, %d, %d]", new Object[]{PdfMemoryUsageSetting.class.getSimpleName(), this.mode, this.maxMemoryBytes, this.maxStorageBytes});
    }

    public static enum Mode {
        MEMORY_FULL,
        MEMORY_BUFFERED,
        FILE,
        MIXED;

    }
}

