/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.MessageStatus;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfDifferencesFinder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PdfSignatureFieldPositionChecker {
    private StatusAlert alertOnSignatureFieldOverlap = new ExceptionOnStatusAlert();
    private StatusAlert alertOnSignatureFieldOutsidePageDimensions = new ExceptionOnStatusAlert();
    private StatusAlert alertOnDocumentReadException = new ExceptionOnStatusAlert();

    public void setAlertOnSignatureFieldOverlap(StatusAlert alertOnSignatureFieldOverlap) {
        Objects.requireNonNull(alertOnSignatureFieldOverlap, "StatusAlert cannot be null!");
        this.alertOnSignatureFieldOverlap = alertOnSignatureFieldOverlap;
    }

    public void setAlertOnSignatureFieldOutsidePageDimensions(StatusAlert alertOnSignatureFieldOutsidePageDimensions) {
        Objects.requireNonNull(alertOnSignatureFieldOutsidePageDimensions, "StatusAlert cannot be null!");
        this.alertOnSignatureFieldOutsidePageDimensions = alertOnSignatureFieldOutsidePageDimensions;
    }

    public void setAlertOnDocumentReadException(StatusAlert alertOnDocumentReadException) {
        this.alertOnDocumentReadException = alertOnDocumentReadException;
    }

    public void assertSignatureFieldPositionValid(PdfDocumentReader documentReader, AnnotationBox annotationBox, int pageNumber) {
        AnnotationBox pageBox = documentReader.getPageBox(pageNumber);
        this.checkSignatureFieldAgainstPageDimensions(annotationBox, pageBox);
        List<PdfAnnotation> pdfAnnotations = this.getAnnotations(documentReader, pageNumber);
        this.checkSignatureFieldBoxOverlap(annotationBox, pdfAnnotations);
    }

    protected void checkSignatureFieldBoxOverlap(AnnotationBox signatureFieldBox, List<PdfAnnotation> pdfAnnotations) {
        DefaultPdfDifferencesFinder pdfDifferencesFinder = new DefaultPdfDifferencesFinder();
        if (pdfDifferencesFinder.isAnnotationBoxOverlapping(signatureFieldBox, pdfAnnotations)) {
            this.alertOnSignatureFieldOverlap();
        }
    }

    private void alertOnSignatureFieldOverlap() {
        MessageStatus status = new MessageStatus();
        status.setMessage("The new signature field position overlaps with an existing annotation!");
        this.alertOnSignatureFieldOverlap.alert(status);
    }

    protected void checkSignatureFieldAgainstPageDimensions(AnnotationBox signatureFieldBox, AnnotationBox pageBox) {
        if (signatureFieldBox.getMinX() < pageBox.getMinX() || signatureFieldBox.getMaxX() > pageBox.getMaxX() || signatureFieldBox.getMinY() < pageBox.getMinY() || signatureFieldBox.getMaxY() > pageBox.getMaxY()) {
            this.alertOnSignatureFieldOutsidePageDimensions(signatureFieldBox, pageBox);
        }
    }

    private void alertOnSignatureFieldOutsidePageDimensions(AnnotationBox signatureFieldBox, AnnotationBox pageBox) {
        MessageStatus status = new MessageStatus();
        status.setMessage(String.format("The new signature field position is outside the page dimensions! Signature Field : [minX=%s, maxX=%s, minY=%s, maxY=%s], Page : [minX=%s, maxX=%s, minY=%s, maxY=%s]", Float.valueOf(signatureFieldBox.getMinX()), Float.valueOf(signatureFieldBox.getMaxX()), Float.valueOf(signatureFieldBox.getMinY()), Float.valueOf(signatureFieldBox.getMaxY()), Float.valueOf(pageBox.getMinX()), Float.valueOf(pageBox.getMaxX()), Float.valueOf(pageBox.getMinY()), Float.valueOf(pageBox.getMaxY())));
        this.alertOnSignatureFieldOutsidePageDimensions.alert(status);
    }

    private List<PdfAnnotation> getAnnotations(PdfDocumentReader documentReader, int pageNumber) {
        try {
            return documentReader.getPdfAnnotations(pageNumber);
        }
        catch (IOException e) {
            this.alertOnDocumentReadException(e);
            return Collections.emptyList();
        }
    }

    private void alertOnDocumentReadException(Exception e) {
        MessageStatus status = new MessageStatus();
        status.setMessage(String.format("An error occurred while reading PDF document! Reason : %s", e.getMessage()));
        this.alertOnDocumentReadException.alert(status);
    }
}

