/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.json;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.policy.Abstract19322CryptographicSuite;
import eu.europa.esig.dss.model.policy.EncryptionAlgorithmWithMinKeySize;
import eu.europa.esig.json.JsonObjectWrapper;
import eu.europa.esig.json.RFC3339DateUtils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicSuiteJsonWrapper
extends Abstract19322CryptographicSuite {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicSuiteJsonWrapper.class);
    private final JsonObjectWrapper securitySuitabilityPolicy;

    public CryptographicSuiteJsonWrapper(JsonObjectWrapper securitySuitabilityPolicy) {
        Objects.requireNonNull(securitySuitabilityPolicy, "securitySuitabilityPolicy cannot be null!");
        this.securitySuitabilityPolicy = securitySuitabilityPolicy;
    }

    @Override
    public String getPolicyName() {
        JsonObjectWrapper policyName = this.securitySuitabilityPolicy.getAsObject("PolicyName");
        if (policyName != null) {
            return policyName.getAsString("Name");
        }
        return null;
    }

    @Override
    protected Map<DigestAlgorithm, Date> buildAcceptableDigestAlgorithmsWithExpirationDates() {
        LinkedHashMap<DigestAlgorithm, Date> digestAlgorithmsMap = new LinkedHashMap<DigestAlgorithm, Date>();
        List<JsonObjectWrapper> algorithmList = this.securitySuitabilityPolicy.getAsObjectList("Algorithm");
        for (JsonObjectWrapper algorithm : algorithmList) {
            JsonObjectWrapper algorithmIdentifier = algorithm.getAsObject("AlgorithmIdentifier");
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(algorithmIdentifier);
            if (digestAlgorithm == null) continue;
            try {
                Date currentEndDate;
                List<JsonObjectWrapper> evaluationList = algorithm.getAsObjectList("Evaluation");
                Date endDate = this.getDigestAlgorithmEndDate(evaluationList);
                if (digestAlgorithmsMap.containsKey(digestAlgorithm) && ((currentEndDate = (Date)digestAlgorithmsMap.get(digestAlgorithm)) == null || endDate != null && currentEndDate.after(endDate))) {
                    endDate = currentEndDate;
                }
                digestAlgorithmsMap.put(digestAlgorithm, endDate);
            }
            catch (Exception e) {
                String errorMessage = "An error occurred during processing of a digest algorithm '{}' entry : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, digestAlgorithm.getName(), e.getMessage(), e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)digestAlgorithm.getName(), (Object)e.getMessage());
            }
        }
        return digestAlgorithmsMap;
    }

    private DigestAlgorithm getDigestAlgorithm(JsonObjectWrapper algorithmIdentifier) {
        String uri;
        if (algorithmIdentifier == null) {
            return null;
        }
        String objectIdentifier = algorithmIdentifier.getAsString("ObjectIdentifier");
        if (objectIdentifier != null && !objectIdentifier.isEmpty()) {
            try {
                return DigestAlgorithm.forOID(objectIdentifier);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((uri = algorithmIdentifier.getAsString("URI")) != null && !uri.isEmpty()) {
            try {
                return DigestAlgorithm.forXML(uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private Date getDigestAlgorithmEndDate(List<JsonObjectWrapper> evaluations) {
        if (evaluations == null || evaluations.isEmpty()) {
            return null;
        }
        Date latestEndDate = null;
        for (JsonObjectWrapper evaluation : evaluations) {
            JsonObjectWrapper validity = evaluation.getAsObject("Validity");
            if (validity == null) continue;
            Date endDate = this.getValidityEndDate(validity);
            if (endDate == null) {
                return null;
            }
            if (latestEndDate != null && !latestEndDate.before(endDate)) continue;
            latestEndDate = endDate;
        }
        return latestEndDate;
    }

    @Override
    protected Map<EncryptionAlgorithmWithMinKeySize, Date> buildAcceptableEncryptionAlgorithmsWithExpirationDates() {
        EncryptionAlgorithm encryptionAlgorithm;
        LinkedHashMap encryptionAlgorithmWithKeySizesMap = new LinkedHashMap();
        List<JsonObjectWrapper> algorithmList = this.securitySuitabilityPolicy.getAsObjectList("Algorithm");
        for (JsonObjectWrapper algorithm : algorithmList) {
            JsonObjectWrapper algorithmIdentifier = algorithm.getAsObject("AlgorithmIdentifier");
            encryptionAlgorithm = this.getEncryptionAlgorithm(algorithmIdentifier);
            if (encryptionAlgorithm == null) continue;
            TreeMap<Integer, Date> keySizeMap = encryptionAlgorithmWithKeySizesMap.getOrDefault(encryptionAlgorithm, new TreeMap());
            try {
                List<JsonObjectWrapper> evaluationList = algorithm.getAsObjectList("Evaluation");
                Map<Integer, Date> endDatesMap = this.getEncryptionAlgorithmKeySizeEndDates(encryptionAlgorithm, evaluationList);
                for (Map.Entry<Integer, Date> entry : endDatesMap.entrySet()) {
                    Date currentEndDate;
                    Map.Entry higherEntry;
                    Date currentEndDate2;
                    Integer keySize = entry.getKey();
                    Date keySizeEndDate = entry.getValue();
                    Map.Entry floorEntry = keySizeMap.floorEntry(keySize);
                    if (floorEntry != null && ((currentEndDate2 = (Date)floorEntry.getValue()) == null || keySizeEndDate != null && currentEndDate2.after(keySizeEndDate))) {
                        keySizeEndDate = currentEndDate2;
                    }
                    if ((higherEntry = keySizeMap.higherEntry(keySize)) != null && (currentEndDate = (Date)higherEntry.getValue()) != null && (keySizeEndDate == null || currentEndDate.before(keySizeEndDate))) {
                        keySizeMap.put(higherEntry.getKey(), keySizeEndDate);
                    }
                    keySizeMap.put(keySize, keySizeEndDate);
                }
                encryptionAlgorithmWithKeySizesMap.put(encryptionAlgorithm, keySizeMap);
            }
            catch (Exception e) {
                String errorMessage = "An error occurred during processing of an encryption algorithm '{}' entry : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, encryptionAlgorithm.getName(), e.getMessage(), e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)encryptionAlgorithm.getName(), (Object)e.getMessage());
            }
        }
        LinkedHashMap<EncryptionAlgorithmWithMinKeySize, Date> encryptionAlgorithmsMap = new LinkedHashMap<EncryptionAlgorithmWithMinKeySize, Date>();
        for (Map.Entry entry : encryptionAlgorithmWithKeySizesMap.entrySet()) {
            encryptionAlgorithm = (EncryptionAlgorithm)entry.getKey();
            for (Map.Entry keySizeEntry : ((TreeMap)entry.getValue()).entrySet()) {
                encryptionAlgorithmsMap.put(new EncryptionAlgorithmWithMinKeySize(encryptionAlgorithm, (Integer)keySizeEntry.getKey()), (Date)keySizeEntry.getValue());
            }
        }
        return encryptionAlgorithmsMap;
    }

    private EncryptionAlgorithm getEncryptionAlgorithm(JsonObjectWrapper algorithmIdentifier) {
        String uri;
        if (algorithmIdentifier == null) {
            return null;
        }
        String objectIdentifier = algorithmIdentifier.getAsString("ObjectIdentifier");
        if (objectIdentifier != null && !objectIdentifier.isEmpty()) {
            try {
                return EncryptionAlgorithm.forOID(objectIdentifier);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID(objectIdentifier);
                    return signatureAlgorithm.getEncryptionAlgorithm();
                }
                catch (IllegalArgumentException signatureAlgorithm) {
                    // empty catch block
                }
            }
        }
        if ((uri = algorithmIdentifier.getAsString("URI")) != null && !uri.isEmpty()) {
            try {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML(uri);
                return signatureAlgorithm.getEncryptionAlgorithm();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private Map<Integer, Date> getEncryptionAlgorithmKeySizeEndDates(EncryptionAlgorithm encryptionAlgorithm, List<JsonObjectWrapper> evaluations) {
        if (evaluations == null || evaluations.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, Date> keySizeEndDates = new LinkedHashMap<Integer, Date>();
        for (JsonObjectWrapper evaluation : evaluations) {
            List<JsonObjectWrapper> parameters = evaluation.getAsObjectList("Parameter");
            Integer keySize = this.getKeySize(encryptionAlgorithm, parameters);
            JsonObjectWrapper validity = evaluation.getAsObject("Validity");
            if (validity == null) continue;
            Date endDate = this.getValidityEndDate(validity);
            keySizeEndDates.put(keySize, endDate);
        }
        return keySizeEndDates;
    }

    private Integer getKeySize(EncryptionAlgorithm encryptionAlgorithm, List<JsonObjectWrapper> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return 0;
        }
        Integer keySize = 0;
        for (JsonObjectWrapper parameter : parameters) {
            Number maxKeyLength = parameter.getAsNumber("Max");
            if (maxKeyLength != null) {
                LOG.debug("The Max key length parameter is not supported. The value has been skipped.");
            }
            String name = parameter.getAsString("name");
            Number minKeyLength = parameter.getAsNumber("Min");
            if (minKeyLength == null) {
                minKeyLength = 0;
            }
            if ("moduluslength".equals(name)) {
                if (EncryptionAlgorithm.RSA.isEquivalent(encryptionAlgorithm)) {
                    return minKeyLength.intValue();
                }
            } else if ("plength".equals(name)) {
                if (EncryptionAlgorithm.DSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.ECDSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.EDDSA.isEquivalent(encryptionAlgorithm)) {
                    return minKeyLength.intValue();
                }
            } else if (!"qlength".equals(name)) {
                LOG.warn("Unknown Algorithms Parameter type '{}'!", (Object)name);
            }
            keySize = minKeyLength.intValue();
        }
        return keySize;
    }

    private Date getValidityEndDate(JsonObjectWrapper validity) {
        Date startDate = this.getAsDate(validity.getAsString("Start"));
        if (startDate != null) {
            LOG.debug("The Start date is not supported. The values has been skipped.");
        }
        return this.getAsDate(validity.getAsString("End"));
    }

    private Date getAsDate(String dateString) {
        if (dateString != null) {
            return RFC3339DateUtils.getDate(dateString);
        }
        return null;
    }

    @Override
    public Date getCryptographicSuiteUpdateDate() {
        String policyIssueDate = this.securitySuitabilityPolicy.getAsString("PolicyIssueDate");
        if (policyIssueDate != null) {
            return RFC3339DateUtils.getDateTime(policyIssueDate);
        }
        return null;
    }
}

