/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.http.commons;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCertificateLoader
implements Serializable {
    private static final long serialVersionUID = -2560386894555266018L;
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertificateLoader.class);
    private CommonsDataLoader commonsDataLoader;

    public void setCommonsDataLoader(CommonsDataLoader commonsDataLoader) {
        this.commonsDataLoader = commonsDataLoader;
    }

    protected CommonsDataLoader getCommonsDataLoader() {
        if (this.commonsDataLoader == null) {
            this.commonsDataLoader = new CommonsDataLoader();
        }
        return this.commonsDataLoader;
    }

    public List<CertificateToken> getCertificates(String urlString) {
        String trimmedUrl = Utils.trim(urlString);
        if (Protocol.isHttpUrl(trimmedUrl)) {
            Certificate[] httpGetCertificates = this.httpGetCertificates(trimmedUrl);
            return this.toCertificateTokens(httpGetCertificates);
        }
        throw new UnsupportedOperationException(String.format("DSS framework supports only HTTP(S) certificate extraction. Obtained URL : '%s'", urlString));
    }

    protected Certificate[] httpGetCertificates(String url) {
        HttpGet httpRequest = null;
        CloseableHttpClient client = null;
        CommonsDataLoader dataLoader = this.getCommonsDataLoader();
        try {
            httpRequest = dataLoader.getHttpRequest(url);
            client = dataLoader.getHttpClient(url);
            HttpHost targetHost = dataLoader.getHttpHost(httpRequest);
            HttpContext localContext = dataLoader.getHttpContext(targetHost);
            NoSenseHttpClientResponseHandler httpClientResponseHandler = new NoSenseHttpClientResponseHandler();
            client.execute(targetHost, httpRequest, localContext, httpClientResponseHandler);
            Certificate[] certificateArray = this.readCertificates(localContext);
            dataLoader.closeQuietly(httpRequest, client);
            return certificateArray;
        }
        catch (Exception e) {
            try {
                throw new DSSExternalResourceException(String.format("Unable to process GET call for url [%s]. Reason : [%s]", url, DSSUtils.getExceptionMessage(e)), e);
            }
            catch (Throwable throwable) {
                dataLoader.closeQuietly(httpRequest, client);
                throw throwable;
            }
        }
    }

    protected List<CertificateToken> toCertificateTokens(Certificate[] certificates) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (Certificate certificate : certificates) {
            try {
                certificateTokens.add(DSSUtils.loadCertificate(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOG.warn("Cannot read and/or create an instance of a CertificateToken for a certificate : '{}'. The entry is skipped. Reason : {}", (Object)certificate, (Object)e.getMessage());
            }
        }
        return certificateTokens;
    }

    protected Certificate[] readCertificates(HttpContext context) throws IOException {
        if (context instanceof HttpCoreContext) {
            HttpCoreContext httpCoreContext = (HttpCoreContext)context;
            SSLSession sslSession = httpCoreContext.getSSLSession();
            if (sslSession != null) {
                return sslSession.getPeerCertificates();
            }
        } else {
            throw new IllegalStateException("HttpContext shall be an instance of class type 'HttpCoreContext'!");
        }
        return new Certificate[0];
    }

    protected static class NoSenseHttpClientResponseHandler
    implements HttpClientResponseHandler<byte[]> {
        protected NoSenseHttpClientResponseHandler() {
        }

        @Override
        public byte[] handleResponse(ClassicHttpResponse classicHttpResponse) {
            if (classicHttpResponse != null) {
                EntityUtils.consumeQuietly(classicHttpResponse.getEntity());
                Utils.closeQuietly(classicHttpResponse);
            }
            return DSSUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

