/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignatureCryptographicVerification;
import eu.europa.esig.dss.model.signature.SignatureDigestReference;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignatureProductionPlace;
import eu.europa.esig.dss.model.signature.SignerRole;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.signature.identifier.SignatureIdentifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public interface AdvancedSignature
extends IdentifierBasedObject,
Serializable {
    public String getFilename();

    public void setFilename(String var1);

    public List<DSSDocument> getDetachedContents();

    public void setDetachedContents(List<DSSDocument> var1);

    public List<DSSDocument> getContainerContents();

    public void setContainerContents(List<DSSDocument> var1);

    public ManifestFile getManifestFile();

    public void setManifestFile(ManifestFile var1);

    public void setSigningCertificateSource(CertificateSource var1);

    public SignatureForm getSignatureForm();

    public SignatureAlgorithm getSignatureAlgorithm();

    public EncryptionAlgorithm getEncryptionAlgorithm();

    public DigestAlgorithm getDigestAlgorithm();

    public Date getSigningTime();

    public SignatureCertificateSource getCertificateSource();

    public ListCertificateSource getCompleteCertificateSource();

    public OfflineRevocationSource<CRL> getCRLSource();

    public OfflineRevocationSource<OCSP> getOCSPSource();

    public ListRevocationSource<CRL> getCompleteCRLSource();

    public ListRevocationSource<OCSP> getCompleteOCSPSource();

    public TimestampSource getTimestampSource();

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate();

    public void initBaselineRequirementsChecker(CertificateVerifier var1);

    public void setMasterSignature(AdvancedSignature var1);

    public AdvancedSignature getMasterSignature();

    public boolean isCounterSignature();

    public CertificateToken getSigningCertificateToken();

    public void checkSignatureIntegrity();

    public SignatureCryptographicVerification getSignatureCryptographicVerification();

    public SignaturePolicy getSignaturePolicy();

    public SignaturePolicyStore getSignaturePolicyStore();

    public SignatureProductionPlace getSignatureProductionPlace();

    public List<CommitmentTypeIndication> getCommitmentTypeIndications();

    public String getContentType();

    public String getMimeType();

    public List<SignerRole> getSignerRoles();

    public List<SignerRole> getSignedAssertions();

    public List<SignerRole> getClaimedSignerRoles();

    public List<SignerRole> getCertifiedSignerRoles();

    public List<CertificateToken> getCertificates();

    public List<TimestampToken> getContentTimestamps();

    public List<TimestampToken> getSignatureTimestamps();

    public List<TimestampToken> getTimestampsX1();

    public List<TimestampToken> getTimestampsX2();

    public List<TimestampToken> getArchiveTimestamps();

    public List<TimestampToken> getDocumentTimestamps();

    public List<TimestampToken> getDetachedTimestamps();

    public List<TimestampToken> getAllTimestamps();

    public void addExternalTimestamp(TimestampToken var1);

    public List<AdvancedSignature> getCounterSignatures();

    public List<EvidenceRecord> getEmbeddedEvidenceRecords();

    public void addExternalEvidenceRecord(EvidenceRecord var1);

    public List<EvidenceRecord> getDetachedEvidenceRecords();

    public List<EvidenceRecord> getAllEvidenceRecords();

    @Override
    public SignatureIdentifier getDSSId();

    public String getId();

    public String getDAIdentifier();

    public SignatureLevel getDataFoundUpToLevel();

    public boolean hasBProfile();

    public boolean hasTProfile();

    public boolean hasLTProfile();

    public boolean hasLTAProfile();

    public boolean hasBESProfile();

    public boolean hasEPESProfile();

    public boolean hasExtendedTProfile();

    public boolean hasCProfile();

    public boolean hasXProfile();

    public boolean hasXLProfile();

    public boolean hasAProfile();

    public boolean hasERSProfile();

    public boolean areAllSelfSignedCertificates();

    public List<String> getStructureValidationResult();

    public List<SignatureScope> getSignatureScopes();

    public boolean isDocHashOnlyValidation();

    public boolean isHashOnlyValidation();

    public byte[] getSignatureValue();

    public List<ReferenceValidation> getReferenceValidations();

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm var1);

    public Digest getDataToBeSignedRepresentation();
}

