/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.analyzer;

import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.identifier.OriginalIdentifierProvider;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignaturePolicyValidationResult;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.analyzer.timestamp.TimestampAnalyzer;
import eu.europa.esig.dss.spi.validation.executor.DefaultValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.scope.EvidenceRecordScopeFinder;
import eu.europa.esig.dss.spi.validation.timestamp.DetachedTimestampSource;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultDocumentAnalyzer
implements DocumentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDocumentAnalyzer.class);
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected List<DSSDocument> detachedEvidenceRecordDocuments = new ArrayList<DSSDocument>();
    protected List<DSSDocument> containerContents;
    protected ManifestFile manifestFile;
    protected CertificateSource signingCertificateSource;
    private Date validationTime;
    protected CertificateVerifier certificateVerifier;
    private ValidationContextExecutor validationContextExecutor = DefaultValidationContextExecutor.INSTANCE;
    private TokenIdentifierProvider tokenIdentifierProvider = new OriginalIdentifierProvider();
    private SignaturePolicyProvider signaturePolicyProvider;
    private List<AdvancedSignature> signatures;
    private List<TimestampToken> detachedTimestamps;
    private List<EvidenceRecord> evidenceRecords;

    protected DefaultDocumentAnalyzer() {
    }

    public static DocumentAnalyzer fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentAnalyzerFactory> serviceLoaders = ServiceLoader.load(DocumentAnalyzerFactory.class);
        for (DocumentAnalyzerFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    @Override
    public DSSDocument getDocument() {
        if (this.document == null) {
            throw new IllegalStateException("Document is not provided! Please use a different constructor to extract the document.");
        }
        return this.document;
    }

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.signingCertificateSource = signingCertificateSource;
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setValidationContextExecutor(ValidationContextExecutor validationContextExecutor) {
        this.validationContextExecutor = validationContextExecutor;
    }

    @Override
    public TokenIdentifierProvider getTokenIdentifierProvider() {
        return this.tokenIdentifierProvider;
    }

    @Override
    public void setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        Objects.requireNonNull(tokenIdentifierProvider);
        this.tokenIdentifierProvider = tokenIdentifierProvider;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setDetachedEvidenceRecordDocuments(List<DSSDocument> detachedEvidenceRecordDocuments) {
        this.detachedEvidenceRecordDocuments = detachedEvidenceRecordDocuments;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    @Override
    public Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public void setDetachedEvidenceRecords(List<EvidenceRecord> evidenceRecords) {
        this.evidenceRecords = evidenceRecords;
    }

    protected SignaturePolicyProvider getSignaturePolicyProvider() {
        if (this.signaturePolicyProvider == null) {
            LOG.info("Default SignaturePolicyProvider instantiated with NativeHTTPDataLoader.");
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader(new NativeHTTPDataLoader());
        }
        return this.signaturePolicyProvider;
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    @Override
    public ValidationContext validate() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "Document is not provided to the validator");
        List<AdvancedSignature> allSignatures = this.getAllSignatures();
        List<TimestampToken> allDetachedTimestamps = this.getDetachedTimestamps();
        List<EvidenceRecord> allDetachedEvidenceRecords = this.getDetachedEvidenceRecords();
        CertificateVerifier certificateVerifierForValidation = new CertificateVerifierBuilder(this.certificateVerifier).buildCompleteCopyForValidation();
        ValidationContext validationContext = this.prepareValidationContext(allSignatures, allDetachedTimestamps, allDetachedEvidenceRecords, certificateVerifierForValidation);
        this.validateContext(validationContext);
        return validationContext;
    }

    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps, Collection<EvidenceRecord> detachedEvidenceRecords, CertificateVerifier certificateVerifier) {
        ValidationContext validationContext = this.createValidationContext();
        validationContext.initialize(certificateVerifier);
        this.prepareSignatureValidationContext(validationContext, signatures);
        this.prepareDetachedTimestampValidationContext(validationContext, detachedTimestamps);
        this.prepareDetachedEvidenceRecordValidationContext(validationContext, detachedEvidenceRecords);
        return validationContext;
    }

    protected ValidationContext createValidationContext() {
        return new SignatureValidationContext(this.getValidationTime());
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures) {
        return this.getValidationData(signatures, Collections.emptyList());
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        if (Utils.isCollectionEmpty(signatures) && Utils.isCollectionEmpty(detachedTimestamps)) {
            throw new DSSException("At least one signature or a timestamp shall be provided to extract the validation data!");
        }
        ValidationContext validationContext = this.prepareValidationContext(signatures, detachedTimestamps, Collections.emptyList(), this.certificateVerifier);
        this.validateContext(validationContext);
        ValidationDataContainer validationDataContainer = this.instantiateValidationDataContainer();
        for (AdvancedSignature signature : signatures) {
            ValidationData signatureValidationData = validationContext.getValidationData(signature);
            validationDataContainer.addValidationData(signature, signatureValidationData);
            for (TimestampToken timestampToken : signature.getAllTimestamps()) {
                ValidationData timestampValidationData = validationContext.getValidationData(timestampToken);
                validationDataContainer.addValidationData(timestampToken, timestampValidationData);
            }
            for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
                ValidationData counterSignatureValidationData = validationContext.getValidationData(counterSignature);
                validationDataContainer.addValidationData(counterSignature, counterSignatureValidationData);
                for (TimestampToken timestampToken : counterSignature.getAllTimestamps()) {
                    ValidationData timestampValidationData = validationContext.getValidationData(timestampToken);
                    validationDataContainer.addValidationData(timestampToken, timestampValidationData);
                }
            }
        }
        for (TimestampToken detachedTimestamp : detachedTimestamps) {
            ValidationData timestampValidationData = validationContext.getValidationData(detachedTimestamp);
            validationDataContainer.addValidationData(detachedTimestamp, timestampValidationData);
        }
        return validationDataContainer;
    }

    protected ValidationDataContainer instantiateValidationDataContainer() {
        return new ValidationDataContainer();
    }

    protected List<EvidenceRecord> getAllEvidenceRecords(List<AdvancedSignature> signatures, List<EvidenceRecord> detachedEvidenceRecords) {
        ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
        for (AdvancedSignature signature : signatures) {
            result.addAll(signature.getEmbeddedEvidenceRecords());
        }
        result.addAll(detachedEvidenceRecords);
        return result;
    }

    protected <T extends AdvancedSignature> void prepareSignatureValidationContext(ValidationContext validationContext, Collection<T> allSignatures) {
        this.prepareSignatureForVerification(validationContext, allSignatures);
        this.processSignaturesValidation(allSignatures);
    }

    protected <T extends AdvancedSignature> void prepareSignatureForVerification(ValidationContext validationContext, Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            validationContext.addSignatureForVerification(signature);
        }
    }

    protected void prepareDetachedTimestampValidationContext(ValidationContext validationContext, Collection<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    protected void prepareDetachedEvidenceRecordValidationContext(ValidationContext validationContext, Collection<EvidenceRecord> evidenceRecords) {
        for (EvidenceRecord evidenceRecord : evidenceRecords) {
            validationContext.addEvidenceRecordForVerification(evidenceRecord);
        }
    }

    protected void validateContext(ValidationContext validationContext) {
        this.validationContextExecutor.validate(validationContext);
    }

    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        return new DefaultSignaturePolicyValidatorLoader();
    }

    protected List<AdvancedSignature> getAllSignatures() {
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : this.getSignatures()) {
            allSignatureList.add(signature);
            this.appendCounterSignatures(allSignatureList, signature);
        }
        this.appendExternalEvidenceRecords(allSignatureList);
        return allSignatureList;
    }

    protected void appendCounterSignatures(List<AdvancedSignature> allSignatureList, AdvancedSignature signature) {
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            counterSignature.initBaselineRequirementsChecker(this.certificateVerifier);
            this.validateSignaturePolicy(counterSignature);
            allSignatureList.add(counterSignature);
            this.appendCounterSignatures(allSignatureList, counterSignature);
        }
    }

    protected void appendExternalEvidenceRecords(List<AdvancedSignature> allSignatureList) {
        List<EvidenceRecord> detachedEvidenceRecords = this.getDetachedEvidenceRecords();
        if (Utils.isCollectionNotEmpty(detachedEvidenceRecords) && Utils.isCollectionNotEmpty(allSignatureList)) {
            for (AdvancedSignature signature : allSignatureList) {
                for (EvidenceRecord evidenceRecord : detachedEvidenceRecords) {
                    if (!this.coversSignature(signature, evidenceRecord)) continue;
                    signature.addExternalEvidenceRecord(evidenceRecord);
                }
            }
        }
    }

    protected void appendExternalEvidenceRecords(TimestampToken timestampToken) {
        DetachedTimestampSource detachedTimestampSource = new DetachedTimestampSource(timestampToken);
        for (EvidenceRecord evidenceRecord : this.getDetachedEvidenceRecords()) {
            if (!this.isTimestampCoveredByEvidenceRecord(timestampToken, evidenceRecord)) continue;
            timestampToken.addDetachedEvidenceRecord(evidenceRecord);
            detachedTimestampSource.addExternalEvidenceRecord(evidenceRecord);
        }
    }

    protected boolean isTimestampCoveredByEvidenceRecord(TimestampToken timestampToken, EvidenceRecord evidenceRecord) {
        return true;
    }

    protected boolean coversSignature(AdvancedSignature signature, EvidenceRecord evidenceRecord) {
        return true;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures == null) {
            this.signatures = this.buildSignatures();
        }
        return this.signatures;
    }

    protected List<AdvancedSignature> buildSignatures() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        if (this.detachedTimestamps == null) {
            this.detachedTimestamps = this.buildDetachedTimestamps();
        }
        return this.detachedTimestamps;
    }

    protected List<TimestampToken> buildDetachedTimestamps() {
        return Collections.emptyList();
    }

    protected List<TimestampAnalyzer> getTimestampReaders() {
        return Collections.emptyList();
    }

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        if (this.evidenceRecords == null) {
            this.evidenceRecords = this.buildDetachedEvidenceRecords();
        }
        return this.evidenceRecords;
    }

    protected List<EvidenceRecord> buildDetachedEvidenceRecords() {
        if (Utils.isCollectionNotEmpty(this.detachedEvidenceRecordDocuments)) {
            ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
            for (DSSDocument evidenceRecordDocument : this.detachedEvidenceRecordDocuments) {
                EvidenceRecord evidenceRecord = this.buildEvidenceRecord(evidenceRecordDocument);
                if (evidenceRecord == null) continue;
                result.add(evidenceRecord);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected EvidenceRecord buildEvidenceRecord(DSSDocument evidenceRecordDocument) {
        try {
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument(evidenceRecordDocument);
            evidenceRecordAnalyzer.setDetachedContents(this.getSignatureEvidenceRecordDetachedContents());
            evidenceRecordAnalyzer.setCertificateVerifier(this.certificateVerifier);
            return this.getEvidenceRecord(evidenceRecordAnalyzer);
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("An error occurred on attempt to read an evidence record document with name '{}' : {}. Please ensure the corresponding module is loaded.", (Object)evidenceRecordDocument.getName(), (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("An error occurred on attempt to read an evidence record document with name '{}' : {}", evidenceRecordDocument.getName(), e.getMessage(), e);
        }
        return null;
    }

    private List<DSSDocument> getSignatureEvidenceRecordDetachedContents() {
        ArrayList<DSSDocument> erDetachedContents = new ArrayList<DSSDocument>();
        erDetachedContents.add(this.document);
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            erDetachedContents.addAll(this.detachedContents);
        }
        return erDetachedContents;
    }

    protected EvidenceRecord getEvidenceRecord(EvidenceRecordAnalyzer evidenceRecordAnalyzer) {
        EvidenceRecord evidenceRecord = evidenceRecordAnalyzer.getEvidenceRecord();
        if (evidenceRecord != null) {
            List<SignatureScope> evidenceRecordScopes = this.getEvidenceRecordScopes(evidenceRecord);
            evidenceRecord.setEvidenceRecordScopes(evidenceRecordScopes);
            evidenceRecord.setTimestampedReferences(this.getTimestampedReferences(evidenceRecordScopes));
            return evidenceRecord;
        }
        return null;
    }

    protected List<SignatureScope> getEvidenceRecordScopes(EvidenceRecord evidenceRecord) {
        return new EvidenceRecordScopeFinder(evidenceRecord).findEvidenceRecordScope();
    }

    protected <T extends AdvancedSignature> void processSignaturesValidation(Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSignatureIntegrity();
        }
    }

    protected List<TimestampedReference> getTimestampedReferences(List<SignatureScope> signatureScopes) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                if (!this.addReference(signatureScope)) continue;
                timestampedReferences.add(new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return timestampedReferences;
    }

    protected boolean addReference(SignatureScope signatureScope) {
        return true;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        AdvancedSignature advancedSignature = this.getSignatureById(signatureId);
        if (advancedSignature != null) {
            return this.getOriginalDocuments(advancedSignature);
        }
        return Collections.emptyList();
    }

    public AdvancedSignature getSignatureById(String signatureId) {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null!");
        for (AdvancedSignature advancedSignature : this.getSignatures()) {
            AdvancedSignature signature = this.findSignatureRecursively(advancedSignature, signatureId);
            if (signature == null) continue;
            return signature;
        }
        return null;
    }

    private AdvancedSignature findSignatureRecursively(AdvancedSignature signature, String signatureId) {
        if (this.doesIdMatch(signature, signatureId)) {
            return signature;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            AdvancedSignature advancedSignature = this.findSignatureRecursively(counterSignature, signatureId);
            if (advancedSignature == null) continue;
            return advancedSignature;
        }
        return null;
    }

    private boolean doesIdMatch(AdvancedSignature signature, String signatureId) {
        return signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier()) || signatureId.equals(this.tokenIdentifierProvider.getIdAsString(signature));
    }

    protected void validateSignaturePolicy(AdvancedSignature signature) {
        SignaturePolicy signaturePolicy = signature.getSignaturePolicy();
        if (signaturePolicy != null) {
            SignaturePolicyStore signaturePolicyStore = signature.getSignaturePolicyStore();
            DSSDocument policyContent = this.extractSignaturePolicyContent(signaturePolicy, signaturePolicyStore);
            signaturePolicy.setPolicyContent(policyContent);
            SignaturePolicyValidator signaturePolicyValidator = this.getSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
            SignaturePolicyValidationResult validationResult = signaturePolicyValidator.validate(signaturePolicy);
            signaturePolicy.setValidationResult(validationResult);
        }
    }

    private DSSDocument extractSignaturePolicyContent(SignaturePolicy signaturePolicy, SignaturePolicyStore signaturePolicyStore) {
        if (signaturePolicyStore != null) {
            if (signaturePolicyStore.getSignaturePolicyContent() != null) {
                return signaturePolicyStore.getSignaturePolicyContent();
            }
            if (signaturePolicyStore.getSigPolDocLocalURI() != null && this.signaturePolicyProvider != null) {
                return this.signaturePolicyProvider.getSignaturePolicyByUrl(signaturePolicyStore.getSigPolDocLocalURI());
            }
        }
        if (this.signaturePolicyProvider != null) {
            return this.signaturePolicyProvider.getSignaturePolicy(signaturePolicy.getIdentifier(), signaturePolicy.getUri());
        }
        return null;
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

