/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSOCSPSource.class);
    private final transient Store<?> ocspResponsesStore;
    private final transient Store<?> ocspBasicStore;
    protected final transient AttributeTable unsignedAttributes;

    @Deprecated
    protected CMSOCSPSource(CMSSignedData cms, AttributeTable unsignedAttributes) {
        this(cms.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response), cms.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic), unsignedAttributes);
    }

    protected CMSOCSPSource(Store<?> ocspResponsesStore, Store<?> ocspBasicStore, AttributeTable unsignedAttributes) {
        this.ocspResponsesStore = ocspResponsesStore;
        this.ocspBasicStore = ocspBasicStore;
        this.unsignedAttributes = unsignedAttributes;
        this.appendContainedOCSPResponses();
    }

    private void appendContainedOCSPResponses() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationValues, RevocationOrigin.REVOCATION_VALUES);
            this.collectRevocationRefs(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationRefs, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
            this.collectRevocationRefs(this.unsignedAttributes, OID.attributeRevocationRefsOid, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void collectFromSignedData() {
        this.addBasicOcspRespFrom_id_ri_ocsp_response();
        this.addBasicOcspRespFrom_id_pkix_ocsp_basic();
    }

    private void addBasicOcspRespFrom_id_ri_ocsp_response() {
        if (this.ocspResponsesStore == null) {
            return;
        }
        Collection<?> otherRevocationInfoMatches = this.ocspResponsesStore.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof ASN1Sequence) {
                BasicOCSPResp basicOCSPResp;
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                if (otherRevocationInfoMatch.size() == 4) {
                    basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                } else {
                    OCSPResp ocspResp = DSSRevocationUtils.getOcspResp(otherRevocationInfoMatch);
                    basicOCSPResp = DSSRevocationUtils.fromRespToBasic(ocspResp);
                }
                OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                ocspResponseIdentifier.setAsn1ObjectIdentifier(CMSObjectIdentifiers.id_ri_ocsp_response);
                this.addBinary(ocspResponseIdentifier, RevocationOrigin.CMS_SIGNED_DATA);
                continue;
            }
            LOG.warn("Unsupported object type for id_ri_ocsp_response (SHALL be an ASN1Sequence) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void addBasicOcspRespFrom_id_pkix_ocsp_basic() {
        if (this.ocspBasicStore == null) {
            return;
        }
        Collection<?> otherRevocationInfoMatches = this.ocspBasicStore.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof ASN1Sequence) {
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                if (basicOCSPResp != null) {
                    OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                    ocspResponseIdentifier.setAsn1ObjectIdentifier(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                    this.addBinary(ocspResponseIdentifier, RevocationOrigin.CMS_SIGNED_DATA);
                    continue;
                }
                LOG.warn("Unable to create an OCSP response from an objects. The entry is skipped.");
                continue;
            }
            LOG.warn("Unsupported object type for id_pkix_ocsp_basic (SHALL be an ASN1Sequence) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void collectRevocationValues(AttributeTable attributeTable, ASN1ObjectIdentifier revocationValueAttributes, RevocationOrigin origin) {
        Attribute[] attributes;
        for (Attribute attribute : attributes = DSSASN1Utils.getAsn1Attributes(attributeTable, revocationValueAttributes)) {
            Object[] attributeValues = attribute.getAttributeValues();
            if (!Utils.isArrayNotEmpty(attributeValues)) continue;
            for (Object attrValue : attributeValues) {
                this.extractRevocationValues((ASN1Encodable)attrValue, origin);
            }
        }
    }

    private void extractRevocationValues(ASN1Encodable attrValue, RevocationOrigin origin) {
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues(attrValue);
        if (revocationValues != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                try {
                    BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                    OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                    this.addBinary(ocspResponseIdentifier, origin);
                }
                catch (Exception e) {
                    String errorMessage = "Unable to process OCSP binary : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
    }

    private void collectRevocationRefs(AttributeTable unsignedAttributes, ASN1ObjectIdentifier revocationReferencesAttribute, RevocationRefOrigin origin) {
        Object[] attributes = DSSASN1Utils.getAsn1Attributes(unsignedAttributes, revocationReferencesAttribute);
        if (Utils.isArrayEmpty(attributes)) {
            return;
        }
        for (Object attribute : attributes) {
            ASN1Encodable attrValue = DSSASN1Utils.getAsn1Encodable((Attribute)attribute);
            if (attrValue == null) {
                return;
            }
            ASN1Sequence revocationRefs = (ASN1Sequence)attrValue;
            for (int i = 0; i < revocationRefs.size(); ++i) {
                try {
                    CrlOcspRef otherCertId = CrlOcspRef.getInstance(revocationRefs.getObjectAt(i));
                    OcspListID ocspListID = otherCertId.getOcspids();
                    if (ocspListID == null) continue;
                    for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                        OCSPRef ocspRef = new OCSPRef(ocspResponsesID);
                        this.addRevocationReference(ocspRef, origin);
                    }
                    continue;
                }
                catch (Exception e) {
                    String errorMessage = "Unable to process OCSP reference : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
    }
}

