/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRevocationSource<T extends Revocation>
implements RevocationSource<T> {
    private static final long serialVersionUID = 948088043702414489L;
    private static final Logger LOG = LoggerFactory.getLogger(CompositeRevocationSource.class);
    private Map<String, RevocationSource<T>> compositeRevocationSources;

    public void setSources(Map<String, RevocationSource<T>> compositeRevocationSources) {
        this.compositeRevocationSources = compositeRevocationSources;
    }

    @Override
    public RevocationToken<T> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        for (Map.Entry<String, RevocationSource<T>> entry : this.compositeRevocationSources.entrySet()) {
            String sourceKey = entry.getKey();
            RevocationSource<T> source = entry.getValue();
            LOG.debug("Trying to get revocation token with Source '{}'", (Object)sourceKey);
            try {
                RevocationToken<T> ocspToken = source.getRevocationToken(certificateToken, issuerCertificateToken);
                if (ocspToken == null) continue;
                LOG.debug("Successfully retrieved revocation token with Source '{}'", (Object)sourceKey);
                return ocspToken;
            }
            catch (Exception e) {
                LOG.debug("Unable to retrieve the revocation token with Source '{}' : {}", (Object)sourceKey, (Object)e.getMessage());
            }
        }
        LOG.debug("Unable to retrieve the ocsp token ({} tries)", (Object)this.compositeRevocationSources.size());
        return null;
    }
}

