/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryAIASource
implements AIASource {
    private static final long serialVersionUID = -8629948836670094079L;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryAIASource.class);
    protected AIASource proxiedSource;

    protected RepositoryAIASource() {
    }

    public void setProxySource(AIASource proxiedSource) {
        this.proxiedSource = proxiedSource;
    }

    @Override
    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        return this.getCertificatesByAIA(certificateToken, false);
    }

    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken, boolean forceRefresh) {
        Objects.requireNonNull(certificateToken, "CertificateToken shall be provided!");
        List<String> urls = CertificateExtensionsUtils.getCAIssuersAccessUrls(certificateToken);
        if (Utils.isCollectionEmpty(urls)) {
            LOG.info("There is no AIA extension for certificate download.");
            return Collections.emptySet();
        }
        List<String> aiaKeys = this.initCertificateAIAKeys(urls);
        if (forceRefresh) {
            LOG.info("Cache is skipped to retrieve the certificates by AIA for the certificate with Id '{}'", (Object)certificateToken.getDSSIdAsString());
        } else {
            Set<CertificateToken> aiaCertificates = this.extractAIAFromCacheSource(aiaKeys);
            if (Utils.isCollectionNotEmpty(aiaCertificates)) {
                LOG.info("Certificate tokens with AIA '{}' have been loaded from the cache", (Object)urls);
                return aiaCertificates;
            }
        }
        return this.extractAndInsertCertificatesFromProxiedSource(certificateToken, aiaKeys);
    }

    private Set<CertificateToken> extractAndInsertCertificatesFromProxiedSource(CertificateToken certificateToken, List<String> aiaKeys) {
        if (this.proxiedSource == null) {
            LOG.warn("Proxied AIASource is not provided!");
            return Collections.emptySet();
        }
        List<String> existingAIAKeys = this.getExistingAIAKeys();
        for (String aiaKey : aiaKeys) {
            if (!existingAIAKeys.contains(aiaKey)) continue;
            LOG.info("AIA Certificates with key '{}' have been removed from DB", (Object)aiaKey);
            this.removeCertificates(aiaKey);
        }
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        Set<CertificateToken> certificatesTokenByAIA = this.proxiedSource.getCertificatesByAIA(certificateToken);
        if (Utils.isCollectionNotEmpty(certificatesTokenByAIA)) {
            for (CertificateToken certificate : certificatesTokenByAIA) {
                String sourceUrl = this.getCertificateTokenAIAUrl(certificate);
                if (sourceUrl == null) {
                    LOG.warn("Not able to find AIA CA issuers URL for certificate '{}'. CA issuers will not be added to the cache.", (Object)certificateToken.getDSSIdAsString());
                    return certificatesTokenByAIA;
                }
                String aiaKey = this.getAIAKey(sourceUrl);
                this.insertCertificate(aiaKey, certificate);
                result.add(certificate);
            }
            LOG.info("CA issuers for a certificate with Id '{}' are added into the cache", (Object)certificateToken.getDSSIdAsString());
        }
        return result;
    }

    protected String getCertificateTokenAIAUrl(CertificateToken certificateToken) {
        String sourceUrl = certificateToken.getSourceURL();
        if (sourceUrl == null) {
            List<String> aiaUrls = CertificateExtensionsUtils.getCAIssuersAccessUrls(certificateToken);
            if (aiaUrls.size() == 0) {
                LOG.warn("No AIA distribution points have been found for this certificate Token with ID {} ", (Object)certificateToken.getDSSIdAsString());
            } else if (aiaUrls.size() == 1) {
                sourceUrl = aiaUrls.get(0);
            } else {
                sourceUrl = aiaUrls.get(0);
                LOG.debug("There are multiple AIA distribution points for certificate token with ID {} , the first url will be used as Jdbc revocation source key", (Object)certificateToken.getDSSIdAsString());
            }
        }
        return sourceUrl;
    }

    protected abstract List<String> getExistingAIAKeys();

    protected List<String> initCertificateAIAKeys(List<String> aiaUrls) {
        ArrayList<String> keys2 = new ArrayList<String>();
        for (String url : aiaUrls) {
            keys2.add(this.getAIAKey(url));
        }
        return keys2;
    }

    protected String getAIAKey(String aiaUrl) {
        return DSSUtils.getSHA1Digest(aiaUrl);
    }

    protected String getUniqueCertificateAiaId(CertificateToken certificateToken, String aiaUrl) {
        return DSSUtils.getSHA1Digest(certificateToken.getDSSIdAsString() + aiaUrl);
    }

    private Set<CertificateToken> extractAIAFromCacheSource(List<String> aiaKeys) {
        LinkedHashSet<CertificateToken> certificateTokens = new LinkedHashSet<CertificateToken>();
        for (String key : aiaKeys) {
            certificateTokens.addAll(this.findCertificates(key));
        }
        return certificateTokens;
    }

    protected abstract Set<CertificateToken> findCertificates(String var1);

    protected abstract void insertCertificate(String var1, CertificateToken var2);

    protected abstract void removeCertificates(String var1);
}

