/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.RevocationTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import java.util.Arrays;

public class CRLTokenRefMatcher
implements RevocationTokenRefMatcher<CRL> {
    @Override
    public boolean match(RevocationToken<CRL> token, RevocationRef<CRL> reference) {
        CRLToken crlToken = (CRLToken)token;
        CRLRef crlRef = (CRLRef)reference;
        if (crlRef.getDigest() != null) {
            return this.matchByDigest(crlToken, crlRef.getDigest());
        }
        throw new DSSException("Digest is mandatory for comparison");
    }

    @Override
    public boolean match(EncapsulatedRevocationTokenIdentifier<CRL> identifier, RevocationRef<CRL> reference) {
        CRLBinary crlBinary = (CRLBinary)identifier;
        CRLRef crlRef = (CRLRef)reference;
        if (crlRef.getDigest() != null) {
            return this.matchByDigest(crlBinary, crlRef.getDigest());
        }
        throw new DSSException("Digest is mandatory for comparison");
    }

    private boolean matchByDigest(RevocationToken<CRL> token, Digest digest) {
        return Arrays.equals(digest.getValue(), token.getDigest(digest.getAlgorithm()));
    }

    private boolean matchByDigest(EncapsulatedRevocationTokenIdentifier<CRL> identifier, Digest digest) {
        return Arrays.equals(digest.getValue(), identifier.getDigestValue(digest.getAlgorithm()));
    }
}

