/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLTokenRefMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineCRLSource
extends OfflineRevocationSource<CRL> {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineCRLSource.class);
    private final List<CRLValidity> cachedValidCRLValidities = new ArrayList<CRLValidity>();

    protected OfflineCRLSource() {
        super(new CRLTokenRefMatcher());
    }

    @Override
    public List<RevocationToken<CRL>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        Objects.requireNonNull(certificateToken, "The certificate to be verified cannot be null");
        Objects.requireNonNull(issuerToken, "The issuer of the certificate to be verified cannot be null");
        ArrayList<RevocationToken<CRL>> result = new ArrayList<RevocationToken<CRL>>();
        List<CRLValidity> validCRLValiditiesForIssuer = this.getFromCachedCRLValidities(issuerToken);
        if (validCRLValiditiesForIssuer.isEmpty()) {
            Set collectedBinaries = this.getAllRevocationBinaries();
            LOG.trace("--> OfflineCRLSource queried for {} contains: {} element(s).", (Object)certificateToken.getDSSIdAsString(), (Object)collectedBinaries.size());
            for (EncapsulatedRevocationTokenIdentifier binary : collectedBinaries) {
                CRLBinary crlBinary = (CRLBinary)binary;
                try {
                    CRLValidity crlValidity = CRLUtils.buildCRLValidity(crlBinary, issuerToken);
                    if (!crlValidity.isValid()) continue;
                    this.cachedValidCRLValidities.add(crlValidity);
                    validCRLValiditiesForIssuer.add(crlValidity);
                }
                catch (Exception e) {
                    LOG.warn("Unable to retrieve the CRLValidity for CRL with Id '{}' : {}", (Object)crlBinary.asXmlId(), (Object)e.getMessage());
                }
            }
        }
        for (CRLValidity crlValidity : validCRLValiditiesForIssuer) {
            CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
            this.addRevocation(crlToken, crlValidity.getCrlBinary());
            result.add(crlToken);
        }
        LOG.trace("--> OfflineCRLSource found result(s) : {}", (Object)result.size());
        return result;
    }

    private List<CRLValidity> getFromCachedCRLValidities(CertificateToken issuerToken) {
        ArrayList<CRLValidity> result = new ArrayList<CRLValidity>();
        for (CRLValidity validity : this.cachedValidCRLValidities) {
            if (!issuerToken.equals(validity.getIssuerToken())) continue;
            result.add(validity);
        }
        return result;
    }
}

