/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.fx;

import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class DSSFileChooser {
    private final FileChooser fileChooser = new FileChooser();
    private SimpleObjectProperty<File> directoryProperty;

    public DSSFileChooser(String title, String fileExtensionFilter, String ... fileExtensions) {
        this.fileChooser.setTitle(title);
        if (Utils.isStringNotEmpty(fileExtensionFilter) && Utils.isArrayNotEmpty(fileExtensions)) {
            this.fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter(fileExtensionFilter, fileExtensions));
        }
        this.fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("All files", "*"));
    }

    public void bindDirectoryProperty(SimpleObjectProperty<File> directoryProperty) {
        this.directoryProperty = directoryProperty;
        this.fileChooser.initialDirectoryProperty().bindBidirectional(directoryProperty);
    }

    public File showOpenDialog(Window window) {
        File file = this.fileChooser.showOpenDialog(window);
        if (file != null && this.directoryProperty != null) {
            this.directoryProperty.setValue(file.getParentFile());
        }
        return file;
    }

    public List<File> showOpenMultipleDialog(Window window) {
        List<File> files = this.fileChooser.showOpenMultipleDialog(window);
        if (Utils.isCollectionNotEmpty(files) && this.directoryProperty != null) {
            this.directoryProperty.setValue(files.get(0).getParentFile());
        }
        return files;
    }
}

