/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task.report;

import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.standalone.service.FOPService;
import eu.europa.esig.dss.standalone.task.report.GenerateReportTask;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateDetailedReportTask
extends GenerateReportTask {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateDetailedReportTask.class);
    private final XmlDetailedReport detailedReport;

    public GenerateDetailedReportTask(XmlDetailedReport detailedReport) {
        Objects.requireNonNull(detailedReport, "Detailed Report cannot be null!");
        this.detailedReport = detailedReport;
    }

    @Override
    protected DSSDocument call() {
        InMemoryDocument inMemoryDocument;
        LOG.debug("Generating Detailed Report...");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FOPService.getInstance().generateDetailedReport(this.detailedReport, baos);
            inMemoryDocument = new InMemoryDocument(baos.toByteArray(), "Detailed Report.pdf", (MimeType)MimeTypeEnum.PDF);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.throwException("Unable to generate Detailed Report", e);
                return null;
            }
        }
        baos.close();
        return inMemoryDocument;
    }
}

