/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.access;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.DownloadCache;
import eu.europa.esig.dss.tsl.cache.ParsingCache;
import eu.europa.esig.dss.tsl.cache.ValidationCache;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizerCacheAccess
extends ReadOnlyCacheAccess {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizerCacheAccess.class);

    public SynchronizerCacheAccess(DownloadCache downloadCache, ParsingCache parsingCache, ValidationCache validationCache) {
        super(downloadCache, parsingCache, validationCache);
    }

    public void sync(CacheKey key) {
        LOG.debug("Synchronize all desynchronized caches for key {}", (Object)key.getKey());
        if (this.downloadCache.isDesync(key)) {
            this.downloadCache.sync(key);
        }
        if (this.parsingCache.isDesync(key)) {
            this.parsingCache.sync(key);
        }
        if (this.validationCache.isDesync(key)) {
            this.validationCache.sync(key);
        }
    }
}

