/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sha2;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.tsl.sha2.AbstractTrustedListWithSha2Predicate;
import eu.europa.esig.dss.tsl.sha2.DocumentWithSha2;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrustedListWithSha2Predicate
extends AbstractTrustedListWithSha2Predicate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTrustedListWithSha2Predicate.class);
    private long cacheExpirationTime = -1L;

    public void setCacheExpirationTime(long cacheExpirationTime) {
        this.cacheExpirationTime = cacheExpirationTime;
    }

    @Override
    public boolean test(DocumentWithSha2 documentWithSha2) {
        Digest sha2Digest;
        Objects.requireNonNull(documentWithSha2, "Document shall be provided!");
        DSSDocument document = documentWithSha2.getDocument();
        if (document == null) {
            String error = "No cached document has been found.";
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", (Object)error);
            }
            documentWithSha2.addErrorMessage(error);
            return false;
        }
        DSSDocument sha2Document = documentWithSha2.getSha2Document();
        if (sha2Document == null) {
            String error = "No sha2 document has been found.";
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", (Object)error);
            }
            documentWithSha2.addErrorMessage(error);
            return false;
        }
        Digest originalDocumentDigest = this.getOriginalDocumentDigest(document);
        if (!originalDocumentDigest.equals(sha2Digest = this.getSha2Digest(sha2Document))) {
            String error = String.format("Digest present within sha2 file '%s' do not match digest of the cached document '%s'.", new String(DSSUtils.toByteArray(sha2Document)), originalDocumentDigest.getHexValue().toLowerCase());
            LOG.warn(String.format("%s Document name: '%s'", error, document.getName()));
            documentWithSha2.addErrorMessage(error);
            return false;
        }
        Date nextUpdate = this.getNextUpdate(document);
        if (nextUpdate != null && !nextUpdate.after(this.getCurrentTime())) {
            String error = String.format("NextUpdate '%s' has been reached.", DSSUtils.formatDateToRFC(nextUpdate));
            if (LOG.isDebugEnabled()) {
                LOG.debug(error);
            }
            documentWithSha2.addErrorMessage(error);
            return false;
        }
        if (this.isCacheExpired(document)) {
            LOG.info("Cache of the document with name '{}' expired. Request refresh.", (Object)document.getName());
            return false;
        }
        return true;
    }

    protected Date getCurrentTime() {
        return new Date();
    }

    protected boolean isCacheExpired(DSSDocument document) {
        if (this.cacheExpirationTime < 0L) {
            return false;
        }
        if (document instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)document;
            File file = fileDocument.getFile();
            if (!file.exists()) {
                return true;
            }
            long currentTime = new Date().getTime();
            return currentTime - file.lastModified() >= this.cacheExpirationTime;
        }
        return true;
    }
}

