/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.identifier.OriginalIdentifierProvider;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.executor.DefaultValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.validation.executor.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.policy.ValidationPolicyLoader;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import eu.europa.esig.dss.validation.reports.diagnostic.CertificateDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.DiagnosticDataBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidator
implements ProcessExecutorProvider<CertificateProcessExecutor> {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateValidator.class);
    private static final String CERTIFICATE_VALIDATION_POLICY_LOCATION = "/policy/certificate-constraint.xml";
    private final CertificateToken token;
    private Date validationTime;
    private CertificateVerifier certificateVerifier;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    private ValidationContextExecutor validationContextExecutor = DefaultValidationContextExecutor.INSTANCE;
    private Locale locale = Locale.getDefault();
    private CertificateProcessExecutor processExecutor;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    public void setTokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        Objects.requireNonNull(identifierProvider);
        this.identifierProvider = identifierProvider;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public void setValidationContextExecutor(ValidationContextExecutor validationContextExecutor) {
        Objects.requireNonNull(validationContextExecutor);
        this.validationContextExecutor = validationContextExecutor;
    }

    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "Default DigestAlgorithm cannot be nulL!");
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    public CertificateReports validate() {
        return this.validate((DSSDocument)null);
    }

    public CertificateReports validate(URL validationPolicyURL) {
        return this.validate(validationPolicyURL, null);
    }

    public CertificateReports validate(String policyResourcePath) {
        return this.validate(policyResourcePath, null);
    }

    public CertificateReports validate(File policyFile) {
        return this.validate(policyFile, null);
    }

    public CertificateReports validate(DSSDocument policyDocument) {
        return this.validate(policyDocument, null);
    }

    public CertificateReports validate(InputStream policyDataStream) {
        return this.validate(policyDataStream, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CertificateReports validate(URL validationPolicyURL, URL cryptographicSuiteURL) {
        try (InputStream validationPolicyIS = validationPolicyURL != null ? validationPolicyURL.openStream() : null;){
            CertificateReports certificateReports;
            block14: {
                InputStream cryptographicSuiteIS = cryptographicSuiteURL != null ? cryptographicSuiteURL.openStream() : null;
                try {
                    certificateReports = this.validate(validationPolicyIS, cryptographicSuiteIS);
                    if (cryptographicSuiteIS == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cryptographicSuiteIS != null) {
                        try {
                            cryptographicSuiteIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cryptographicSuiteIS.close();
            }
            return certificateReports;
        }
        catch (IOException e) {
            throw new IllegalInputException(String.format("Unable to load policy with URL '%s' and cryptographic suite '%s'. Reason : %s", validationPolicyURL, cryptographicSuiteURL, e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CertificateReports validate(String policyResourcePath, String cryptographicSuitePath) {
        try (InputStream validationPolicyIS = policyResourcePath != null ? this.getClass().getResourceAsStream(policyResourcePath) : null;){
            CertificateReports certificateReports;
            block14: {
                InputStream cryptographicSuiteIS = cryptographicSuitePath != null ? this.getClass().getResourceAsStream(cryptographicSuitePath) : null;
                try {
                    certificateReports = this.validate(validationPolicyIS, cryptographicSuiteIS);
                    if (cryptographicSuiteIS == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cryptographicSuiteIS != null) {
                        try {
                            cryptographicSuiteIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cryptographicSuiteIS.close();
            }
            return certificateReports;
        }
        catch (IOException e) {
            throw new IllegalInputException(String.format("Unable to load policy with URL '%s' and cryptographic suite '%s'. Reason : %s", policyResourcePath, cryptographicSuitePath, e.getMessage()), e);
        }
    }

    public CertificateReports validate(File policyFile, File cryptographicSuiteFile) {
        FileDocument policyDocument = policyFile != null ? new FileDocument(policyFile) : null;
        FileDocument cryptographicSuiteDocument = cryptographicSuiteFile != null ? new FileDocument(cryptographicSuiteFile) : null;
        return this.validate(policyDocument, cryptographicSuiteDocument);
    }

    public CertificateReports validate(DSSDocument policyDocument, DSSDocument cryptographicSuiteDocument) {
        ValidationPolicy validationPolicy = this.loadValidationPolicy(policyDocument, cryptographicSuiteDocument);
        return this.validate(validationPolicy);
    }

    protected ValidationPolicy loadValidationPolicy(DSSDocument policyDocument, DSSDocument cryptographicSuiteDocument) {
        try {
            ValidationPolicyLoader validationPolicyLoader;
            if (policyDocument == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicyLoader = this.fromDefaultCertificateValidationPolicyLoader();
            } else {
                validationPolicyLoader = ValidationPolicyLoader.fromValidationPolicy(policyDocument);
            }
            if (cryptographicSuiteDocument != null) {
                validationPolicyLoader = validationPolicyLoader.withCryptographicSuite(cryptographicSuiteDocument);
            }
            return validationPolicyLoader.create();
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", e);
        }
    }

    protected ValidationPolicyLoader fromDefaultCertificateValidationPolicyLoader() {
        return ValidationPolicyLoader.fromValidationPolicy(CertificateValidator.class.getResourceAsStream(CERTIFICATE_VALIDATION_POLICY_LOCATION));
    }

    public CertificateReports validate(InputStream policyDataStream, InputStream cryptographicSuiteStream) {
        InMemoryDocument policyDocument = policyDataStream != null ? new InMemoryDocument(policyDataStream) : null;
        InMemoryDocument cryptographicSuiteDocument = cryptographicSuiteStream != null ? new InMemoryDocument(cryptographicSuiteStream) : null;
        return this.validate(policyDocument, cryptographicSuiteDocument);
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.getDiagnosticData();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.identifierProvider.getIdAsString(this.token));
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (CertificateReports)executor.execute();
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.token, "Certificate token is not provided to the validator");
    }

    public final XmlDiagnosticData getDiagnosticData() {
        return this.prepareDiagnosticDataBuilder().build();
    }

    protected ValidationContext prepareValidationContext(CertificateVerifier certificateVerifier) {
        ValidationContext svc = this.createValidationContext();
        svc.initialize(certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        return svc;
    }

    protected ValidationContext createValidationContext() {
        return new SignatureValidationContext(this.getValidationTime());
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder() {
        CertificateVerifier certificateVerifierForValidation = new CertificateVerifierBuilder(this.certificateVerifier).buildCompleteCopyForValidation();
        ValidationContext validationContext = this.prepareValidationContext(certificateVerifierForValidation);
        this.validateContext(validationContext);
        return this.createDiagnosticDataBuilder(validationContext);
    }

    protected void validateContext(ValidationContext validationContext) {
        this.validationContextExecutor.validate(validationContext);
    }

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext) {
        return ((CertificateDiagnosticDataBuilder)((CertificateDiagnosticDataBuilder)new CertificateDiagnosticDataBuilder().usedCertificates((Set)validationContext.getProcessedCertificates())).usedRevocations((Set)validationContext.getProcessedRevocations())).allCertificateSources(validationContext.getAllCertificateSources()).defaultDigestAlgorithm(this.defaultDigestAlgorithm).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.identifierProvider).validationDate(this.getValidationTime());
    }

    @Override
    public void setProcessExecutor(CertificateProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public CertificateProcessExecutor getDefaultProcessExecutor() {
        return new DefaultCertificateProcessExecutor();
    }
}

