/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.AbstractSignatureWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.PDFRevisionWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableMimetypeFileContentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableZipCommentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AnnotationChangesCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ByteRangeAllDocumentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ByteRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ByteRangeCollisionCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ContainerTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.DocMDPCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FieldMDPCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FormFillChangesCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ManifestFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.MimeTypeFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PDFAComplianceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PDFAProfileCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfAnnotationOverlapCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfPageDifferenceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfSignatureDictionaryCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfVisualDifferenceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SigFieldLockCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignedFilesPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.UndefinedChangesCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ZipCommentPresentCheck;

public abstract class AbstractFormatChecking<S extends AbstractSignatureWrapper>
extends Chain<XmlFC> {
    protected final DiagnosticData diagnosticData;
    protected final S token;
    protected final Context context;
    protected final ValidationPolicy policy;

    protected AbstractFormatChecking(I18nProvider i18nProvider, DiagnosticData diagnosticData, S token, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlFC());
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.context = context;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.FORMAT_CHECKING;
    }

    protected ChainItem<XmlFC> getPDFRevisionValidationChain(ChainItem<XmlFC> item) {
        PDFRevisionWrapper pdfRevision = ((AbstractSignatureWrapper)this.token).getPDFRevision();
        if (pdfRevision != null) {
            if (item == null) {
                this.firstItem = this.byteRangeCheck();
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.byteRangeCheck());
            }
            item = item.setNextItem(this.byteRangeCollisionCheck());
            item = item.setNextItem(this.byteRangeAllDocumentCheck());
            item = item.setNextItem(this.pdfSignatureDictionaryCheck());
            item = item.setNextItem(this.pdfPageDifferenceCheck());
            item = item.setNextItem(this.pdfAnnotationOverlapCheck());
            item = item.setNextItem(this.pdfVisualDifferenceCheck());
            if (pdfRevision.getDocMDPPermissions() != null) {
                item = item.setNextItem(this.docMDPCheck());
            }
            if (pdfRevision.getFieldMDP() != null) {
                item = item.setNextItem(this.fieldMDPCheck());
            }
            if (pdfRevision.getSigFieldLock() != null) {
                item = item.setNextItem(this.sigFieldLockCheck());
            }
            item = item.setNextItem(this.formFillChangesCheck());
            item = item.setNextItem(this.annotationChangesCheck());
            item = item.setNextItem(this.undefinedChangesCheck());
        }
        return item;
    }

    protected ChainItem<XmlFC> getPdfaValidationChain(ChainItem<XmlFC> item) {
        if (this.diagnosticData.isPDFAValidationPerformed()) {
            if (item == null) {
                this.firstItem = this.pdfaProfileCheck();
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.pdfaProfileCheck());
            }
            item = item.setNextItem(this.pdfaCompliantCheck());
        }
        return item;
    }

    protected ChainItem<XmlFC> getASiCContainerValidationChain(ChainItem<XmlFC> item) {
        if (this.diagnosticData.isContainerInfoPresent()) {
            if (item == null) {
                this.firstItem = this.containerTypeCheck();
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.containerTypeCheck());
            }
            item = item.setNextItem(this.zipCommentPresentCheck());
            if (Utils.isStringNotBlank(this.diagnosticData.getZipComment())) {
                item = item.setNextItem(this.acceptableZipCommentCheck());
            }
            item = item.setNextItem(this.mimetypeFilePresentCheck());
            if (this.diagnosticData.isMimetypeFilePresent()) {
                item = item.setNextItem(this.mimetypeFileContentCheck());
            }
            item = item.setNextItem(this.manifestFilePresentCheck());
            item = item.setNextItem(this.signedFilesPresentCheck());
            item = item.setNextItem(this.filenameAdherenceCheck());
            if (this.manifestExistsForToken()) {
                item = item.setNextItem(this.manifestFilenameAdherenceCheck());
            }
        }
        return item;
    }

    private ChainItem<XmlFC> byteRangeCheck() {
        LevelRule constraint = this.policy.getByteRangeConstraint(this.context);
        return new ByteRangeCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> byteRangeCollisionCheck() {
        LevelRule constraint = this.policy.getByteRangeCollisionConstraint(this.context);
        return new ByteRangeCollisionCheck(this.i18nProvider, (XmlFC)this.result, (AbstractSignatureWrapper)this.token, this.diagnosticData, constraint);
    }

    private ChainItem<XmlFC> byteRangeAllDocumentCheck() {
        LevelRule constraint = this.policy.getByteRangeAllDocumentConstraint(this.context);
        return new ByteRangeAllDocumentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData, constraint);
    }

    private ChainItem<XmlFC> pdfSignatureDictionaryCheck() {
        LevelRule constraint = this.policy.getPdfSignatureDictionaryConstraint(this.context);
        return new PdfSignatureDictionaryCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> pdfPageDifferenceCheck() {
        LevelRule constraint = this.policy.getPdfPageDifferenceConstraint(this.context);
        return new PdfPageDifferenceCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> pdfAnnotationOverlapCheck() {
        LevelRule constraint = this.policy.getPdfAnnotationOverlapConstraint(this.context);
        return new PdfAnnotationOverlapCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> pdfVisualDifferenceCheck() {
        LevelRule constraint = this.policy.getPdfVisualDifferenceConstraint(this.context);
        return new PdfVisualDifferenceCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> docMDPCheck() {
        LevelRule constraint = this.policy.getDocMDPConstraint(this.context);
        return new DocMDPCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> fieldMDPCheck() {
        LevelRule constraint = this.policy.getFieldMDPConstraint(this.context);
        return new FieldMDPCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> sigFieldLockCheck() {
        LevelRule constraint = this.policy.getSigFieldLockConstraint(this.context);
        return new SigFieldLockCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> formFillChangesCheck() {
        LevelRule constraint = this.policy.getFormFillChangesConstraint(this.context);
        return new FormFillChangesCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> annotationChangesCheck() {
        LevelRule constraint = this.policy.getAnnotationChangesConstraint(this.context);
        return new AnnotationChangesCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> undefinedChangesCheck() {
        LevelRule constraint = this.policy.getUndefinedChangesConstraint(this.context);
        return new UndefinedChangesCheck(this.i18nProvider, (XmlFC)this.result, ((AbstractSignatureWrapper)this.token).getPDFRevision(), constraint);
    }

    private ChainItem<XmlFC> pdfaProfileCheck() {
        MultiValuesRule constraint = this.policy.getAcceptablePDFAProfilesConstraint();
        return new PDFAProfileCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getPDFAProfileId(), constraint);
    }

    private ChainItem<XmlFC> pdfaCompliantCheck() {
        LevelRule constraint = this.policy.getPDFACompliantConstraint();
        return new PDFAComplianceCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.isPDFACompliant(), constraint);
    }

    private ChainItem<XmlFC> containerTypeCheck() {
        MultiValuesRule constraint = this.policy.getAcceptedContainerTypesConstraint();
        return new ContainerTypeCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerType(), constraint);
    }

    protected abstract ChainItem<XmlFC> filenameAdherenceCheck();

    protected abstract ChainItem<XmlFC> manifestFilenameAdherenceCheck();

    private ChainItem<XmlFC> zipCommentPresentCheck() {
        LevelRule constraint = this.policy.getZipCommentPresentConstraint();
        return new ZipCommentPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> acceptableZipCommentCheck() {
        MultiValuesRule constraint = this.policy.getAcceptedZipCommentsConstraint();
        return new AcceptableZipCommentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFilePresentCheck() {
        LevelRule constraint = this.policy.getMimeTypeFilePresentConstraint();
        return new MimeTypeFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.isMimetypeFilePresent(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFileContentCheck() {
        MultiValuesRule constraint = this.policy.getAcceptedMimeTypeContentsConstraint();
        return new AcceptableMimetypeFileContentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getMimetypeFileContent(), constraint);
    }

    private ChainItem<XmlFC> manifestFilePresentCheck() {
        LevelRule constraint = this.policy.getManifestFilePresentConstraint();
        return new ManifestFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }

    private ChainItem<XmlFC> signedFilesPresentCheck() {
        LevelRule constraint = this.policy.getSignedFilesPresentConstraint();
        return new SignedFilesPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }

    private boolean manifestExistsForToken() {
        return this.diagnosticData.getManifestFileForFilename(((AbstractSignatureWrapper)this.token).getFilename()) != null;
    }
}

