/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;

public class DigestAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;
    private final CryptographicSuite cryptographicSuite;

    protected DigestAlgorithmReliableCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAcceptableDigestAlgorithmsLevel()));
        this.digestAlgo = digestAlgo;
        this.cryptographicSuite = cryptographicSuite;
    }

    @Override
    protected boolean process() {
        return CryptographicSuiteUtils.isDigestAlgorithmReliable(this.cryptographicSuite, this.digestAlgo);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_DAA, this.getName(this.digestAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        if (this.digestAlgo == null) {
            return this.buildXmlMessage(MessageTag.ASCCM_DAA_ANS_2, new Object[]{this.position});
        }
        return this.buildXmlMessage(MessageTag.ASCCM_DAA_ANS, new Object[]{this.getName(this.digestAlgo), this.position});
    }
}

