/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;

public class PublicKeySizeKnownCheck
extends AbstractCryptographicCheck {
    private final String keySize;

    protected PublicKeySizeKnownCheck(I18nProvider i18nProvider, String keySize, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAcceptableEncryptionAlgorithmsMiniKeySizeLevel()));
        this.keySize = keySize;
    }

    @Override
    protected boolean process() {
        return Utils.isStringDigits(this.keySize);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_PKSK, new Object[0]);
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_PKSK_ANS, new Object[]{this.position});
    }
}

