/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateRefDigestAlgorithmCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SigningCertificateRefDigestAlgorithmCheckChainBuilder<T extends XmlConstraintsConclusion> {
    private final I18nProvider i18nProvider;
    private final T result;
    private final TokenProxy token;
    private final Date validationDate;
    private final Context context;
    private final ValidationPolicy validationPolicy;
    private XmlCryptographicValidation cryptographicValidation;

    public SigningCertificateRefDigestAlgorithmCheckChainBuilder(I18nProvider i18nProvider, T result, Date validationDate, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        this.i18nProvider = i18nProvider;
        this.result = result;
        this.token = token;
        this.validationDate = validationDate;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    public ChainItem<T> build(ChainItem<T> chainItem) {
        if (!this.token.isSigningCertificateReferencePresent()) {
            return chainItem;
        }
        List<CertificateRefWrapper> signingCertificateReferences = this.token.getSigningCertificateReferences();
        CertificateRefWrapper signingCertificateReference = this.token.getSigningCertificateReference();
        HashMap signCertRefsMap = new HashMap();
        signingCertificateReferences.forEach(r -> signCertRefsMap.computeIfAbsent(r.getCertificateId(), s -> new ArrayList()).add(r));
        for (Map.Entry entry : signCertRefsMap.entrySet()) {
            String certificateId = (String)entry.getKey();
            List certificateRefWrappers = (List)entry.getValue();
            SubContext subContext = signingCertificateReference != null && signingCertificateReference.getCertificateId().equals(certificateId) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            SigningCertificateRefDigestAlgorithmCheck<T> signCertCheck = this.signingCertificateRefDigestAlgoCheckResult(certificateRefWrappers, certificateId, subContext);
            chainItem = chainItem == null ? signCertCheck : chainItem.setNextItem(signCertCheck);
            XmlCC cryptoValidationResult = signCertCheck.getCryptographicValidationResult();
            if (this.cryptographicValidation != null && (!this.cryptographicValidation.isSecure() || this.isValid(cryptoValidationResult))) continue;
            this.cryptographicValidation = this.buildCryptographicValidation(cryptoValidationResult, certificateId);
        }
        return chainItem;
    }

    private SigningCertificateRefDigestAlgorithmCheck<T> signingCertificateRefDigestAlgoCheckResult(List<CertificateRefWrapper> signCertRefs, String certificateId, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getSigningCertificateDigestAlgorithmConstraint(this.context);
        return new SigningCertificateRefDigestAlgorithmCheck<T>(this.i18nProvider, this.result, this.validationDate, signCertRefs, certificateId, this.context, subContext, this.validationPolicy, constraint);
    }

    public XmlCryptographicValidation getCryptographicValidation() {
        return this.cryptographicValidation;
    }

    private XmlCryptographicValidation buildCryptographicValidation(XmlCC ccResult, String certificateId) {
        XmlCryptographicValidation xmlCryptographicValidation = new XmlCryptographicValidation();
        xmlCryptographicValidation.setAlgorithm(ccResult.getVerifiedAlgorithm());
        xmlCryptographicValidation.setNotAfter(ccResult.getNotAfter());
        xmlCryptographicValidation.setSecure(this.isValid(ccResult));
        xmlCryptographicValidation.setValidationTime(this.validationDate);
        xmlCryptographicValidation.setConcernedMaterial(this.getTokenDescription(certificateId));
        return xmlCryptographicValidation;
    }

    private boolean isValid(XmlCC xmlConclusion) {
        return xmlConclusion != null && xmlConclusion.getConclusion() != null && Indication.PASSED == xmlConclusion.getConclusion().getIndication();
    }

    private String getTokenDescription(String id) {
        return this.i18nProvider.getMessage(MessageTag.ACCM_DESC_WITH_ID, new Object[]{MessageTag.ACCM_POS_SIG_CERT_REF, id});
    }
}

