/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class CommitmentTypeIndicationsCheck
extends ChainItem<XmlSAV> {
    private final SignatureWrapper signature;
    private final MultiValuesRule constraint;

    public CommitmentTypeIndicationsCheck(I18nProvider i18nProvider, XmlSAV result, SignatureWrapper signature, MultiValuesRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        List<XmlCommitmentTypeIndication> commitmentTypeIndications = this.signature.getCommitmentTypeIndications();
        List<String> expectedValues = this.constraint.getValues();
        if (Utils.isCollectionEmpty(commitmentTypeIndications)) {
            return false;
        }
        if (Utils.isCollectionNotEmpty(expectedValues)) {
            List presentIdentifiers = commitmentTypeIndications.stream().map(XmlCommitmentTypeIndication::getIdentifier).collect(Collectors.toList());
            return expectedValues.containsAll(presentIdentifiers);
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPXTIP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPXTIP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

